/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.collect.CollectionOrder;
import com.pnfsoftware.jeb.util.collect.Maps;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

@Ser
public class MultiMap<K, V> {
    @SerId(value=1)
    private Map<K, List<V>> map;
    @SerId(value=2)
    private int cachedSize;

    public MultiMap() {
        this(CollectionOrder.NONE);
    }

    public MultiMap(CollectionOrder collectionOrder) {
        if (collectionOrder == null) {
            throw new NullPointerException("Illegal key order");
        }
        switch (collectionOrder) {
            case NONE: {
                this.map = new HashMap<K, List<V>>();
                break;
            }
            case INSERTION: {
                this.map = new LinkedHashMap<K, List<V>>();
                break;
            }
            case NATURAL: {
                this.map = new TreeMap<K, List<V>>();
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        this.cachedSize = 0;
    }

    public void clear() {
        this.map.clear();
        this.cachedSize = 0;
    }

    public int keySize() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.cachedSize == 0;
    }

    public int size() {
        return this.cachedSize;
    }

    public int put(K k, V v2) {
        List<V> list = Maps.putMulti(this.map, k, v2);
        ++this.cachedSize;
        return list.size();
    }

    public void putMulti(K k, Collection<? extends V> collection) {
        for (V v2 : collection) {
            this.put(k, v2);
        }
    }

    public void putAll(Map<? extends K, List<? extends V>> map) {
        for (Map.Entry<K, List<V>> entry : map.entrySet()) {
            for (V v2 : entry.getValue()) {
                this.put(entry.getKey(), v2);
            }
        }
    }

    public boolean createKey(K k) {
        List<V> list = this.map.get(k);
        if (list != null) {
            return false;
        }
        this.map.put(k, new ArrayList());
        return true;
    }

    public boolean containsKey(K k) {
        return this.map.containsKey(k);
    }

    public boolean containsValue(V v2) {
        for (List<V> list : this.map.values()) {
            if (!list.contains(v2)) continue;
            return true;
        }
        return false;
    }

    public List<V> get(K k, boolean bl) {
        List<V> list = this.map.get(k);
        if (list != null) {
            return Collections.unmodifiableList(list);
        }
        if (bl) {
            return Collections.emptyList();
        }
        return null;
    }

    public List<V> get(K k) {
        return this.get(k, false);
    }

    public List<V> getSafe(K k) {
        return this.get(k, true);
    }

    public List<V> remove(K k) {
        List<V> list = this.map.remove(k);
        if (list != null) {
            this.cachedSize -= list.size();
        }
        return list;
    }

    public V removeValue(K k, V v2) {
        return this.removeValue(k, v2, false);
    }

    public V removeValue(K k, V v2, boolean bl) {
        List<V> list = this.map.get(k);
        if (list == null) {
            return null;
        }
        if (!list.remove(v2)) {
            return null;
        }
        --this.cachedSize;
        if (bl && list.isEmpty()) {
            this.map.remove(k);
        }
        return v2;
    }

    public int removeMulti(K k, Collection<? extends V> collection) {
        return this.removeMulti(k, collection, false);
    }

    public int removeMulti(K k, Collection<? extends V> collection, boolean bl) {
        List<V> list = this.map.get(k);
        if (collection == null) {
            return 0;
        }
        int n2 = 0;
        for (V v2 : collection) {
            if (!list.remove(v2)) continue;
            --this.cachedSize;
            ++n2;
        }
        if (bl && n2 > 0 && collection.isEmpty()) {
            this.map.remove(k);
        }
        return n2;
    }

    public Collection<V> values() {
        ArrayList<V> arrayList = new ArrayList<V>();
        for (List<V> list : this.map.values()) {
            arrayList.addAll(list);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public boolean removeAll(Collection<K> collection) {
        if (this.isEmpty()) {
            return false;
        }
        for (K k : collection) {
            this.remove(k);
        }
        return true;
    }

    public String toString() {
        return this.map.toString();
    }
}

