/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.function.Predicate;

@Ser
public class MultiList<E> {
    @SerId(value=1)
    private List<List<E>> list = new ArrayList<List<E>>();
    @SerId(value=2)
    private int cachedSize = 0;

    public void clear() {
        this.list.clear();
        this.cachedSize = 0;
    }

    public boolean isEmpty() {
        return this.cachedSize == 0;
    }

    public int size() {
        return this.cachedSize;
    }

    public int put(int n2, E e) {
        while (this.list.size() <= n2) {
            this.list.add(null);
        }
        List<E> list = this.list.get(n2);
        if (list == null) {
            list = new ArrayList();
            this.list.set(n2, list);
        }
        list.add(e);
        ++this.cachedSize;
        return list.size();
    }

    public void putMulti(int n2, Collection<? extends E> collection) {
        for (E e : collection) {
            this.put(n2, e);
        }
    }

    public void putAll(List<List<? extends E>> list) {
        int n2 = 0;
        for (List<E> list2 : list) {
            if (list2 != null) {
                for (E e : list2) {
                    this.put(n2, e);
                }
            }
            ++n2;
        }
    }

    public List<E> get(int n2) {
        List<E> list = null;
        if (n2 >= 0 && n2 < this.list.size()) {
            list = this.list.get(n2);
        }
        if (list != null) {
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public List<E> clear(int n2) {
        List<Object> list = null;
        if (n2 >= 0 && n2 < this.list.size()) {
            list = this.list.get(n2);
        }
        if (list != null) {
            this.list.set(n2, null);
            this.cachedSize -= list.size();
        } else {
            list = Collections.emptyList();
        }
        return list;
    }

    public List<E> remove(int n2) {
        List<Object> list = null;
        if (n2 >= 0 && n2 < this.list.size() && (list = this.list.remove(n2)) != null) {
            this.cachedSize -= list.size();
        }
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }

    public boolean removeElement(int n2, E e) {
        List<E> list = null;
        if (n2 >= 0 && n2 < this.list.size()) {
            list = this.list.get(n2);
        }
        if (list != null && list.remove(e)) {
            this.cachedSize -= list.size();
            return true;
        }
        return false;
    }

    public int removeMultipleElements(int n2, Predicate<E> predicate) {
        List<E> list;
        int n3 = 0;
        if (n2 >= 0 && n2 < this.list.size() && (list = this.list.get(n2)) != null) {
            Iterator<E> iterator = list.iterator();
            while (iterator.hasNext()) {
                E e = iterator.next();
                if (!predicate.test(e)) continue;
                iterator.remove();
                ++n3;
            }
        }
        this.cachedSize -= n3;
        return n3;
    }

    public E findFirstElement(int n2, Predicate<E> predicate) {
        List<E> list;
        if (n2 >= 0 && n2 < this.list.size() && (list = this.list.get(n2)) != null) {
            for (E e : list) {
                if (!predicate.test(e)) continue;
                return e;
            }
        }
        return null;
    }

    public List<E> findAllElements(int n2, Predicate<E> predicate) {
        List<E> list;
        ArrayList<E> arrayList = new ArrayList<E>();
        if (n2 >= 0 && n2 < this.list.size() && (list = this.list.get(n2)) != null) {
            for (E e : list) {
                if (!predicate.test(e)) continue;
                arrayList.add(e);
            }
        }
        return arrayList;
    }

    public Collection<E> values() {
        ArrayList<E> arrayList = new ArrayList<E>();
        for (List<E> list : this.list) {
            if (list == null) continue;
            arrayList.addAll(list);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public NavigableSet<Integer> indexSet() {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        int n2 = 0;
        for (List<E> list : this.list) {
            if (list != null) {
                treeSet.add(n2);
            }
            ++n2;
        }
        return treeSet;
    }

    public String toString() {
        return this.list.toString();
    }
}

