/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class Maps {
    public static <K, V> V get(Map<K, V> map, K k) {
        if (map == null) {
            return null;
        }
        return map.get(k);
    }

    public static <K, V> V get(Map<K, V> map, K k, V v2) {
        if (map == null || !map.containsKey(k)) {
            return v2;
        }
        return map.get(k);
    }

    public static <K, V> HashMap<K, V> toMap(K k, V v2) {
        return (HashMap)Maps.toMap(k, v2, null);
    }

    public static <K, V> HashMap<K, V> toMap(K k, V v2, K k2, V v3) {
        HashMap hashMap = (HashMap)Maps.toMap(k, v2, null);
        hashMap.put(k2, v3);
        return hashMap;
    }

    public static <K, V> HashMap<K, V> toMap(K k, V v2, K k2, V v3, K k3, V v4) {
        HashMap hashMap = (HashMap)Maps.toMap(k, v2, null);
        hashMap.put(k2, v3);
        hashMap.put(k3, v4);
        return hashMap;
    }

    public static <K, V> Map<K, V> toMap(K k, V v2, Class<? extends Map> clazz) {
        Map<K, V> map = null;
        if (clazz != null) {
            try {
                map = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {}
        }
        if (map == null) {
            map = new HashMap<K, V>();
        }
        map.put(k, v2);
        return map;
    }

    public static <K, V extends Comparable<V>> List<V> getSortedValues(Map<K, V> map, final boolean bl) {
        ArrayList<V> arrayList = new ArrayList<V>(map.values());
        Collections.sort(arrayList, new Comparator<V>(){

            @Override
            public int compare(V v2, V v3) {
                int n2 = v2.compareTo(v3);
                return bl ? n2 : -n2;
            }
        });
        return arrayList;
    }

    public static <K, V extends Comparable<V>> List<V> getSortedValues(Map<K, V> map) {
        return Maps.getSortedValues(map, true);
    }

    public static <K, V extends Comparable<V>> LinkedHashMap<K, V> createSortedMapByValue(Map<K, V> map, final boolean bl) {
        ArrayList<Map.Entry<K, V>> arrayList = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(arrayList, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> entry, Map.Entry<K, V> entry2) {
                int n2 = ((Comparable)entry.getValue()).compareTo((Comparable)entry2.getValue());
                return bl ? n2 : -n2;
            }
        });
        LinkedHashMap linkedHashMap = new LinkedHashMap(arrayList.size());
        for (Map.Entry entry : arrayList) {
            linkedHashMap.put(entry.getKey(), (Comparable)entry.getValue());
        }
        return linkedHashMap;
    }

    public static <V> String putNoOverwrite(Map<String, V> map, String string, V v2) {
        Object object = string;
        int n2 = 0;
        while (map.containsKey(object)) {
            object = Strings.safe(string, "null") + "." + ++n2;
        }
        map.put((String)object, v2);
        return object;
    }

    public static <K> boolean removeAll(Map<K, ?> map, Collection<? extends K> collection) {
        return map.keySet().removeAll(collection);
    }

    public static <K> boolean retainAll(Map<K, ?> map, Collection<? extends K> collection) {
        return map.keySet().retainAll(collection);
    }

    public static <K, V> List<V> addMulti(Map<K, List<V>> map, K k) {
        List<V> list = map.get(k);
        if (list == null) {
            list = new ArrayList<V>(1);
            map.put(k, list);
        }
        return list;
    }

    public static <K, V> List<V> putMulti(Map<K, List<V>> map, K k, V v2) {
        List<V> list = map.get(k);
        if (list == null) {
            list = new ArrayList<V>(1);
            map.put(k, list);
        }
        list.add(v2);
        return list;
    }

    public static <K, V> List<V> putMulti(Map<K, List<V>> map, K k, Collection<V> collection) {
        List<V> list = map.get(k);
        if (list == null) {
            list = new ArrayList<V>(collection.size());
            map.put(k, list);
        }
        list.addAll(collection);
        return list;
    }

    public static <K, V, C extends Collection<V>> boolean putMulti(Map<K, C> map, K k, V v2, Supplier<C> supplier) {
        Collection collection = (Collection)map.get(k);
        if (collection == null) {
            collection = (Collection)supplier.get();
            map.put(k, collection);
        }
        return collection.add(v2);
    }

    public static <K, V, C extends Collection<V>> Collection<V> collectMulti(Map<K, C> map) {
        ArrayList arrayList = new ArrayList(map.size());
        for (Collection collection : map.values()) {
            arrayList.addAll(collection);
        }
        return arrayList;
    }

    public static <K, V, C extends Collection<V>> boolean removeMulti(Map<K, C> map, K k, V v2) {
        Collection collection = (Collection)map.get(k);
        if (collection == null) {
            return false;
        }
        if (!collection.remove(v2)) {
            return false;
        }
        if (collection.isEmpty()) {
            map.remove(k);
        }
        return true;
    }

    public static <K, V> int removeForValue(Map<K, V> map, V v2, boolean bl) {
        if (v2 == null) {
            throw new IllegalArgumentException("Null value");
        }
        ArrayList<K> arrayList = new ArrayList<K>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (bl && v2 == entry.getValue()) {
                arrayList.add(entry.getKey());
                continue;
            }
            if (bl || !v2.equals(entry.getValue())) continue;
            arrayList.add(entry.getKey());
        }
        map.keySet().removeAll(arrayList);
        return arrayList.size();
    }

    public static <K, V extends Comparable<V>> List<Map.Entry<K, V>> getSortedEntriesByValue(Map<K, V> map) {
        return Maps.getSortedEntriesByValue(map, false);
    }

    public static <K, V extends Comparable<V>> List<Map.Entry<K, V>> getSortedEntriesByValue(Map<K, V> map, final boolean bl) {
        ArrayList<Map.Entry<K, V>> arrayList = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(arrayList, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> entry, Map.Entry<K, V> entry2) {
                Comparable comparable = (Comparable)entry.getValue();
                Comparable comparable2 = (Comparable)entry2.getValue();
                if (comparable == null) {
                    return comparable2 == null ? 0 : 1;
                }
                if (comparable2 == null) {
                    return comparable == null ? 0 : -1;
                }
                int n2 = comparable.compareTo(comparable2);
                return bl ? -n2 : n2;
            }
        });
        return arrayList;
    }
}

