/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class Lists {
    public static <T extends Comparable<T>> int addSorted(List<T> list, T comparable) {
        int n2;
        for (n2 = 0; n2 < list.size(); ++n2) {
            if (comparable.compareTo((Comparable)((Comparable)list.get(n2))) > 0) continue;
            list.add(n2, comparable);
            break;
        }
        list.add(n2, comparable);
        return n2;
    }

    public static <T> ArrayList<T> createArrayList() {
        return new ArrayList();
    }

    public static <T> ArrayList<T> createArrayList(T t) {
        ArrayList<T> arrayList = new ArrayList<T>();
        arrayList.add(t);
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T> ArrayList<T> createArrayList(Collection<? extends T> ... collectionArray) {
        void var5_8;
        int n2 = 0;
        for (Collection<T> collection : collectionArray) {
            n2 += collection.size();
        }
        ArrayList arrayList = new ArrayList(n2);
        Collection<? extends T>[] collectionArray2 = collectionArray;
        int n3 = collectionArray2.length;
        boolean bl = false;
        while (var5_8 < n3) {
            Collection<? extends T> collection = collectionArray2[var5_8];
            arrayList.addAll(collection);
            ++var5_8;
        }
        return arrayList;
    }

    @SafeVarargs
    public static <T> ArrayList<T> newArrayList(T ... TArray) {
        ArrayList<T> arrayList = new ArrayList<T>(TArray.length);
        for (T t : TArray) {
            arrayList.add(t);
        }
        return arrayList;
    }

    public static <T> List<T> add(List<T> list, List<T> list2) {
        if (list2 != null) {
            list.addAll(list2);
        }
        return list;
    }

    public static <T> List<T> addNonNulls(List<T> list, List<? extends T> list2) {
        if (list2 != null) {
            for (T t : list2) {
                if (t == null) continue;
                list.add(t);
            }
        }
        return list;
    }

    @SafeVarargs
    public static <T> List<T> addNonNulls(List<T> list, T ... TArray) {
        for (T t : TArray) {
            if (t == null) continue;
            list.add(t);
        }
        return list;
    }

    public static <T> List<T> subList(List<T> list, int n2) {
        return list.subList(n2, list.size());
    }

    public static <T> T get(List<? extends T> list, int n2, T t) {
        if (list == null || n2 < 0 || n2 >= list.size()) {
            return t;
        }
        return list.get(n2);
    }

    public static <T> T get(List<? extends T> list, int n2) {
        return Lists.get(list, n2, null);
    }

    public static <T> T getFirst(List<? extends T> list) {
        return Lists.get(list, 0);
    }

    public static <T> ListIterator<T> reverseIterator(List<T> list) {
        return list.listIterator(list.size());
    }

    public static <T> List<T> reverse(List<T> list) {
        int n2 = list.size();
        int n3 = 0;
        int n4 = n2 - 1;
        while (n3 < n2 / 2) {
            T t = list.get(n3);
            list.set(n3, list.get(n4));
            list.set(n4, t);
            ++n3;
            --n4;
        }
        return list;
    }

    public static <T, R> List<? extends R> map(Collection<T> collection, Function<? super T, ? extends R> function) {
        return collection.stream().map(function).collect(Collectors.toList());
    }

    public static <T> T set(List<T> list, int n2, T t, T t2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Negative index: " + n2);
        }
        while (n2 >= list.size()) {
            list.add(t2);
        }
        return list.set(n2, t);
    }

    public static <T> T set(List<T> list, int n2, T t) {
        return Lists.set(list, n2, t, null);
    }

    public static <T> void add(List<T> list, int n2, T t, T t2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Negative index: " + n2);
        }
        while (n2 > list.size()) {
            list.add(t2);
        }
        list.add(n2, t);
    }

    public static <T> void add(List<T> list, int n2, T t) {
        Lists.add(list, n2, t, null);
    }

    public static <T> List<T> safe(List<T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public static <T> List<T> fromIterator(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList());
    }

    public static <T extends Comparable<T>> void insertIntoSortedList(List<T> list, T t) {
        Lists.insertIntoSortedList(list, t, null, false);
    }

    public static <T> void insertIntoSortedList(List<T> list, T t, Comparator<T> comparator, boolean bl) {
        int n2 = 0;
        int n3 = 0;
        int n4 = list.size();
        int n5 = 0;
        int n6 = n4;
        while (n5 < n6) {
            n2 = n5 + (n6 - n5) / 2;
            T t2 = list.get(n2);
            n3 = comparator == null ? ((Comparable)t).compareTo(t2) : comparator.compare(t, t2);
            if (n3 == 0) break;
            if (bl) {
                n3 = -n3;
            }
            if (n3 == 1) {
                n5 = n2 + 1;
                continue;
            }
            n6 = n2;
        }
        if (n3 > 0) {
            list.add(n6, t);
        } else if (n3 < 0) {
            list.add(n5, t);
        } else {
            list.add(n2, t);
        }
    }

    public static <T> void rotate(List<T> list, boolean bl) {
        Lists.rotate(list, bl, 0, list.size() - 1);
    }

    public static <T> void rotate(List<T> list, boolean bl, int n2, int n3) {
        if (n2 >= n3) {
            return;
        }
        if (bl) {
            T t = list.get(n3);
            for (int i = n3; i > n2; --i) {
                list.set(i, list.get(i - 1));
            }
            list.set(n2, t);
        } else {
            T t = list.get(n2);
            for (int i = n2; i < n3; ++i) {
                list.set(i, list.get(i + 1));
            }
            list.set(n3, t);
        }
    }

    public static <T> T last(List<T> list) {
        return list == null || list.isEmpty() ? null : (T)list.get(list.size() - 1);
    }
}

