/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.events.Event;
import com.pnfsoftware.jeb.util.events.EventSource;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@SerDisabled
public class ItemHistory<T>
extends EventSource {
    private static final ILogger logger = GlobalLog.getLogger(ItemHistory.class, Integer.MAX_VALUE);
    int capacity;
    boolean cleanHistoryAfterIndex;
    private List<T> history = new ArrayList<T>();
    private int index = 0;

    public ItemHistory() {
        this(100, true);
    }

    public ItemHistory(int n2, boolean bl) {
        this.capacity(n2);
        this.cleanHistoryAfterIndex = bl;
    }

    public void reset() {
        this.history.clear();
        this.index = 0;
        this.notifyListeners(new Event());
    }

    public int size() {
        return this.history.size();
    }

    public int capacity() {
        return this.capacity;
    }

    public void capacity(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("Invalid capacity: " + n2);
        }
        this.capacity = n2;
        this.trim();
    }

    private void trim() {
        if (this.history.size() <= this.capacity) {
            return;
        }
        int n2 = 0;
        while (this.history.size() > this.capacity) {
            this.history.remove(0);
            ++n2;
        }
        this.index = Math.max(0, this.index - n2);
        this.notifyListeners(new Event());
    }

    public int position() {
        return this.index;
    }

    public void add(T t) {
        if (this.cleanHistoryAfterIndex) {
            while (this.index < this.history.size()) {
                this.history.remove(this.index);
            }
        }
        this.history.add(t);
        this.index = this.history.size();
        this.notifyListeners(new Event());
        this.trim();
    }

    public void addAll(Collection<T> collection) {
        if (this.cleanHistoryAfterIndex) {
            while (this.index < this.history.size()) {
                this.history.remove(this.index);
            }
        }
        this.history.addAll(collection);
        this.index = this.history.size();
        this.notifyListeners(new Event());
        this.trim();
    }

    public boolean remove(T t) {
        for (int i = this.history.size() - 1; i >= 0; --i) {
            if (!this.history.get(i).equals(t)) continue;
            this.history.remove(i);
            if (i < this.index) {
                --this.index;
            }
            this.notifyListeners(new Event());
            return true;
        }
        return false;
    }

    public T getMostRecent() {
        if (this.history.isEmpty()) {
            return null;
        }
        return this.history.get(this.history.size() - 1);
    }

    public List<T> get() {
        return new ArrayList<T>(this.history);
    }

    public T peekPrevious() {
        if (this.index == 0) {
            return null;
        }
        return this.history.get(this.index - 1);
    }

    public T peekNext() {
        if (this.index == this.history.size()) {
            return null;
        }
        return this.history.get(this.index);
    }

    public T getPrevious() {
        return this.getPrevious(null);
    }

    public T getPrevious(T t) {
        if (this.index == 0) {
            return null;
        }
        --this.index;
        T t2 = this.history.get(this.index);
        if (t != null) {
            this.history.set(this.index, t);
        }
        this.notifyListeners(new Event());
        return t2;
    }

    public T getAt(int n2, T t) {
        if (this.index < 0 || n2 > this.history.size() || this.index == n2) {
            return null;
        }
        this.index = n2;
        T t2 = null;
        if (this.index != this.history.size()) {
            t2 = this.history.get(this.index);
        }
        if (t != null) {
            this.history.set(this.index, t);
        }
        this.notifyListeners(new Event());
        return t2;
    }

    public T getNext() {
        return this.getNext(null);
    }

    public T getNext(T t) {
        if (this.index == this.history.size()) {
            return null;
        }
        T t2 = this.history.get(this.index);
        if (t != null) {
            this.history.set(this.index, t);
        }
        ++this.index;
        this.notifyListeners(new Event());
        return t2;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.history.size();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.history.size(); ++i) {
            String string = i == this.position() ? "->" : "  ";
            Strings.ff(stringBuilder, "%s %s\n", string, this.history.get(i));
        }
        if (this.position() == this.history.size()) {
            stringBuilder.append("->\n");
        }
        return stringBuilder.toString();
    }
}

