/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.io.EndianUtil;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
public class IntMap {
    private static final ILogger logger = GlobalLog.getLogger(IntMap.class);
    @SerId(value=1)
    private byte[][][] level0 = new byte[65536][][];
    @SerId(value=2)
    private int cnt;

    public int size() {
        return this.cnt;
    }

    public boolean isEmpty() {
        return this.cnt == 0;
    }

    public void clear() {
        this.level0 = new byte[65536][][];
        this.cnt = 0;
    }

    private int find(byte[] byArray, int n2) {
        int n3 = 0;
        int n4 = byArray.length / 5;
        while (n3 < n4) {
            int n5 = n3 + (n4 - n3) / 2;
            int n6 = byArray[n5 * 5] & 0xFF;
            if (n6 > n2) {
                n4 = n5;
                continue;
            }
            if (n6 < n2) {
                n3 = n5 + 1;
                continue;
            }
            return n5;
        }
        return -n3 - 1;
    }

    public int put(int n2, int n3) {
        byte[] byArray;
        int n4 = 0;
        int n5 = n2 >>> 16;
        int n6 = n2 >> 8 & 0xFF;
        int n7 = n2 & 0xFF;
        Object object = this.level0[n5];
        if (object == null) {
            object = new byte[256][];
            this.level0[n5] = object;
        }
        if ((byArray = object[n6]) == null) {
            byArray = new byte[5];
            object[n6] = byArray;
            byArray[0] = (byte)n7;
            EndianUtil.intToLEBytes(n3, byArray, 1);
            ++this.cnt;
        } else {
            int n8 = this.find(byArray, n7);
            if (n8 >= 0) {
                n4 = EndianUtil.littleEndianBytesToInt(byArray, (n8 *= 5) + 1);
                EndianUtil.intToLEBytes(n3, byArray, n8 + 1);
                if (n4 != n3) {
                    ++this.cnt;
                }
            } else {
                n8 = -(n8 + 1) * 5;
                byte[] byArray2 = new byte[byArray.length + 5];
                System.arraycopy(byArray, 0, byArray2, 0, n8);
                byArray2[n8] = (byte)n7;
                EndianUtil.intToLEBytes(n3, byArray2, n8 + 1);
                System.arraycopy(byArray, n8, byArray2, n8 + 5, byArray.length - n8);
                object[n6] = byArray2;
                ++this.cnt;
            }
        }
        return n4;
    }

    public int get(int n2) {
        int n3;
        int n4 = n2 >>> 16;
        int n5 = n2 >> 8 & 0xFF;
        int n6 = n2 & 0xFF;
        byte[][] byArray = this.level0[n4];
        if (byArray == null) {
            return 0;
        }
        byte[] byArray2 = byArray[n5];
        if (byArray2 == null) {
            return 0;
        }
        if (byArray2.length == 1280) {
            n3 = n6;
        } else {
            n3 = this.find(byArray2, n6);
            if (n3 < 0) {
                return 0;
            }
        }
        return EndianUtil.littleEndianBytesToInt(byArray2, n3 * 5 + 1);
    }

    public boolean containsKey(int n2) {
        int n3;
        int n4 = n2 >>> 16;
        int n5 = n2 >> 8 & 0xFF;
        int n6 = n2 & 0xFF;
        byte[][] byArray = this.level0[n4];
        if (byArray == null) {
            return false;
        }
        byte[] byArray2 = byArray[n5];
        if (byArray2 == null) {
            return false;
        }
        return byArray2.length == 1280 || (n3 = this.find(byArray2, n6)) >= 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        int n2 = 0;
        int n3 = 0;
        for (byte[][] byArray : this.level0) {
            if (byArray != null) {
                int n4 = 0;
                for (byte[] byArray2 : byArray) {
                    if (byArray2 != null) {
                        for (int i = 0; i < byArray2.length; i += 5) {
                            int n5 = byArray2[i] & 0xFF;
                            int n6 = EndianUtil.littleEndianBytesToInt(byArray2, i + 1);
                            if (n6 == 0) continue;
                            int n7 = n3 << 16 | n4 << 8 | n5;
                            if (n2 > 0) {
                                stringBuilder.append(", ");
                            }
                            stringBuilder.append(n7).append("=").append(n6);
                            ++n2;
                        }
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

