/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Ser
public class IntList {
    private static final int SIZE_INCREASE_MULTIPLIER = 2;
    @SerId(value=1)
    private int initialCapacity;
    @SerId(value=2)
    private int bucketCapacity;
    @SerId(value=3)
    private int cnt;
    @SerId(value=4)
    private int[] list0;
    @SerId(value=5)
    private List<int[]> listX;

    public IntList() {
        this(16, 65536);
    }

    public IntList(int n2, int n3) {
        Assert.a(n2 > 0 && n3 >= n2);
        this.initialCapacity = n2;
        this.bucketCapacity = n3;
        this.list0 = new int[n2];
    }

    public int size() {
        return this.cnt;
    }

    public boolean isEmpty() {
        return this.cnt == 0;
    }

    public void clear() {
        this.cnt = 0;
        this.list0 = new int[this.initialCapacity];
        this.listX = null;
    }

    public int get(int n2) {
        if (n2 < 0 || n2 >= this.cnt) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        int n3 = n2 / this.bucketCapacity;
        int n4 = n2 % this.bucketCapacity;
        int[] nArray = this.getBucket(n3, false);
        return nArray[n4];
    }

    public void add(int n2) {
        int n3 = this.cnt % this.bucketCapacity;
        int n4 = this.cnt / this.bucketCapacity;
        int[] nArray = this.getBucket(n4, true);
        if (n3 >= nArray.length) {
            nArray = this.increaseBucket(nArray);
            this.setBucket(n4, nArray);
        }
        nArray[n3] = n2;
        ++this.cnt;
    }

    public void set(int n2, int n3) {
        if (n2 < 0 || n2 >= this.cnt) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        int n4 = n2 / this.bucketCapacity;
        int n5 = n2 % this.bucketCapacity;
        int[] nArray = this.getBucket(n4, false);
        nArray[n5] = n3;
    }

    private int[] getBucket(int n2, boolean bl) {
        int[] nArray;
        if (n2 == 0) {
            nArray = this.list0;
        } else {
            if (this.listX == null) {
                Assert.a(n2 == 1);
                this.listX = new ArrayList<int[]>(16);
            }
            if (n2 - 1 == this.listX.size()) {
                Assert.a(bl);
                nArray = new int[this.initialCapacity];
                this.listX.add(nArray);
            } else if (this.listX != null && n2 - 1 < this.listX.size()) {
                nArray = this.listX.get(n2 - 1);
            } else {
                throw new RuntimeException();
            }
        }
        return nArray;
    }

    private void setBucket(int n2, int[] nArray) {
        if (n2 == 0) {
            this.list0 = nArray;
        } else if (n2 - 1 == this.listX.size()) {
            this.listX.add(nArray);
        } else if (n2 - 1 < this.listX.size()) {
            this.listX.set(n2 - 1, nArray);
        } else {
            throw new RuntimeException();
        }
    }

    private int[] increaseBucket(int[] nArray) {
        int n2 = Math.min(2 * nArray.length, this.bucketCapacity);
        return Arrays.copyOf(nArray, n2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        int n2 = 0;
        for (int n3 : this.list0) {
            if (n2 >= this.cnt) break;
            if (n2 >= 1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(n3);
            ++n2;
        }
        if (this.listX != null) {
            Object object = this.listX.iterator();
            block1: while (object.hasNext()) {
                int[] nArray;
                for (int n4 : nArray = (int[])object.next()) {
                    if (n2 >= this.cnt) continue block1;
                    if (n2 >= 1) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(n4);
                    ++n2;
                }
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

