/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.format.Strings;
import java.util.Arrays;

public class IntGauge {
    private int base;
    private byte[] records;
    private int remaining;

    public IntGauge(int n2) {
        this(0, n2);
    }

    public IntGauge(int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 < 0) {
            throw new IllegalArgumentException();
        }
        this.base = n2;
        this.records = new byte[n4];
        this.remaining = n4;
    }

    public void clear() {
        for (int i = 0; i < this.records.length; ++i) {
            this.records[i] = 0;
        }
        this.remaining = this.records.length;
    }

    public int getBegin() {
        return this.base;
    }

    public int getEnd() {
        return this.base + this.records.length;
    }

    public boolean record(int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 < 0 || n2 < this.base || n3 > this.base + this.records.length) {
            return false;
        }
        for (int i = 0; i < n4; ++i) {
            int n5 = n2 - this.base + i;
            if (this.records[n5] != 0) {
                return false;
            }
            this.records[n5] = 1;
            --this.remaining;
        }
        return true;
    }

    public int getRemaining() {
        return this.remaining;
    }

    public boolean isComplete() {
        return this.remaining == 0;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + this.base;
        n2 = 31 * n2 + Arrays.hashCode(this.records);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        IntGauge intGauge = (IntGauge)object;
        if (this.base != intGauge.base) {
            return false;
        }
        return Arrays.equals(this.records, intGauge.records);
    }

    public String toString() {
        return Strings.ff("[%d-%d):%s%s", this.base, this.base + this.records.length, Arrays.toString(this.records), this.isComplete() ? "->COMPLETED" : "");
    }
}

