/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerConstructor;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

@Ser
public class HashedList<E>
extends AbstractList<E> {
    @SerId(value=1)
    private ArrayList<E> list;
    @SerId(value=2)
    private HashSet<E> set;

    @SerConstructor
    public HashedList() {
        this(10);
    }

    public HashedList(int n2) {
        this.list = new ArrayList(n2);
        this.set = new HashSet(n2);
    }

    public HashedList(Collection<? extends E> collection) {
        this.list = new ArrayList<E>(collection);
        this.set = new HashSet<E>(collection);
    }

    @Override
    public E get(int n2) {
        return this.list.get(n2);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public E set(int n2, E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.set.contains(e)) {
            throw new IllegalArgumentException();
        }
        E e2 = this.list.set(n2, e);
        this.set.remove(e2);
        this.set.add(e);
        return e2;
    }

    @Override
    public void add(int n2, E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.set.contains(e)) {
            throw new IllegalArgumentException();
        }
        this.list.add(n2, e);
        this.set.add(e);
    }

    @Override
    public E remove(int n2) {
        E e = this.list.remove(n2);
        this.set.remove(e);
        return e;
    }

    @Override
    public boolean contains(Object object) {
        return this.set.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.set.containsAll(collection);
    }
}

