/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.collect.Bitmap;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class FastLongSet
extends AbstractSet<Long> {
    private long from;
    private long to;
    private Bitmap bitmap;

    public FastLongSet(long l2, long l3) {
        if (l2 >= l3) {
            throw new IllegalArgumentException("Illegal set bounds");
        }
        long l4 = l3 - l2;
        if (l4 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Set range is too wide");
        }
        this.from = l2;
        this.to = l3;
        this.bitmap = new Bitmap((int)l4);
    }

    public FastLongSet(long l2) {
        this(0L, l2);
    }

    public FastLongSet(FastLongSet fastLongSet) {
        this.from = fastLongSet.from;
        this.to = fastLongSet.to;
        this.bitmap = fastLongSet.bitmap.clone();
    }

    @Override
    public int size() {
        return this.bitmap.countOnes();
    }

    @Override
    public boolean isEmpty() {
        return this.bitmap.isEmpty();
    }

    @Override
    public void clear() {
        this.bitmap.clear();
    }

    @Override
    public boolean add(Long l2) {
        long l3 = l2;
        if (l3 < this.from || l3 >= this.to) {
            throw new IllegalArgumentException();
        }
        return this.bitmap.set((int)(l3 - this.from), true);
    }

    @Override
    public boolean remove(Object object) {
        if (!(object instanceof Long)) {
            throw new IllegalArgumentException();
        }
        long l2 = (Long)object;
        if (l2 < this.from || l2 >= this.to) {
            throw new IllegalArgumentException();
        }
        return this.bitmap.set((int)(l2 - this.from), false);
    }

    @Override
    public boolean contains(Object object) {
        if (!(object instanceof Long)) {
            throw new IllegalArgumentException();
        }
        long l2 = (Long)object;
        if (l2 < this.from || l2 >= this.to) {
            throw new IllegalArgumentException();
        }
        return this.bitmap.get((int)(l2 - this.from));
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection instanceof FastLongSet) {
            FastLongSet fastLongSet = (FastLongSet)collection;
            if (this.from == fastLongSet.from && this.to == fastLongSet.to) {
                return this.bitmap.equals(fastLongSet.bitmap);
            }
        }
        for (Object e : collection) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Long> collection) {
        boolean bl = false;
        for (Long l2 : collection) {
            if (!this.add(l2)) continue;
            bl = true;
        }
        return bl;
    }

    public void addAllFast(FastLongSet fastLongSet) {
        if (this.from != fastLongSet.from || this.to != fastLongSet.to) {
            throw new IllegalArgumentException();
        }
        this.bitmap.addAllFrom(fastLongSet.bitmap);
    }

    @Override
    public Iterator<Long> iterator() {
        return new Iterator<Long>(){
            List<Integer> list;
            int i;
            {
                this.list = FastLongSet.this.bitmap.ones();
                this.i = 0;
            }

            @Override
            public boolean hasNext() {
                return this.i < this.list.size();
            }

            @Override
            public Long next() {
                return (long)this.list.get(this.i++).intValue() + FastLongSet.this.from;
            }
        };
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Strings.ff(stringBuilder, "%d values: [", this.size());
        for (long l2 : this) {
            Strings.ff(stringBuilder, "0x%X, ", l2);
        }
        Strings.ff(stringBuilder, "]", new Object[0]);
        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof FastLongSet) {
            FastLongSet fastLongSet = (FastLongSet)object;
            if (this.from == fastLongSet.from && this.to == fastLongSet.to) {
                return !(this.bitmap == null ? fastLongSet.bitmap != null : !this.bitmap.equals(fastLongSet.bitmap));
            }
        }
        return super.equals(object);
    }
}

