/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Ser
public class DisjointSets<T> {
    @SerId(value=1)
    private List<Set<T>> sets = new ArrayList<Set<T>>();

    public void clear() {
        this.sets.clear();
    }

    public boolean isEmpty() {
        return this.sets.isEmpty();
    }

    public int size() {
        return this.sets.size();
    }

    public int getCountOfValues() {
        int n2 = 0;
        for (Set<T> set : this.sets) {
            n2 += set.size();
        }
        return n2;
    }

    public Set<T> getValues() {
        HashSet<T> hashSet = new HashSet<T>(this.getCountOfValues());
        for (Set<T> set : this.sets) {
            hashSet.addAll(set);
        }
        return hashSet;
    }

    public Collection<Set<T>> getSets() {
        ArrayList arrayList = new ArrayList();
        this.sets.forEach(set -> arrayList.add(Collections.unmodifiableSet(set)));
        return Collections.unmodifiableList(arrayList);
    }

    public boolean add(T t) {
        for (Set<T> set : this.sets) {
            if (!set.contains(t)) continue;
            return false;
        }
        HashSet hashSet = new HashSet();
        hashSet.add(t);
        this.sets.add(hashSet);
        return true;
    }

    public boolean add(T t, T t2) {
        int n2 = -1;
        int n3 = -1;
        for (int i = 0; i < this.sets.size(); ++i) {
            Set<T> set = this.sets.get(i);
            if (n2 < 0 && set.contains(t)) {
                n2 = i;
            }
            if (n3 >= 0 || !set.contains(t2)) continue;
            n3 = i;
        }
        if (n2 < 0 && n3 < 0) {
            HashSet<T> hashSet = new HashSet<T>();
            hashSet.add(t);
            hashSet.add(t2);
            this.sets.add(hashSet);
            return true;
        }
        if (n2 >= 0 && n3 < 0) {
            Set<T> set = this.sets.get(n2);
            return set.add(t2);
        }
        if (n2 < 0 && n3 >= 0) {
            Set<T> set = this.sets.get(n3);
            return set.add(t);
        }
        if (n2 != n3) {
            Set<T> set = this.sets.get(n2);
            set.addAll((Collection)this.sets.remove(n3));
            return true;
        }
        return false;
    }

    public String toString() {
        return this.sets.toString();
    }
}

