/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomInitPostGraph;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@Ser
public class ConcurrentList<T>
implements List<T> {
    @SerId(value=1)
    private List<T> list;
    @SerTransient
    private ReadWriteLock lock;

    @SerCustomInitPostGraph
    private void init() {
        this.lock = new ReentrantReadWriteLock();
    }

    public ConcurrentList() {
        this(new ArrayList());
    }

    public ConcurrentList(int n2) {
        this(new ArrayList(n2));
    }

    public ConcurrentList(ArrayList<T> arrayList) {
        this.list = arrayList;
        this.lock = new ReentrantReadWriteLock();
    }

    @Override
    public boolean isEmpty() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.list.isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int size() {
        this.lock.readLock().lock();
        try {
            int n2 = this.list.size();
            return n2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public T get(int n2) {
        this.lock.readLock().lock();
        try {
            T t = this.list.get(n2);
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public T getSafe(int n2, T t) {
        this.lock.readLock().lock();
        try {
            if (n2 >= this.list.size()) {
                T t2 = t;
                return t2;
            }
            T t3 = this.list.get(n2);
            return t3;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public T set(int n2, T t) {
        this.lock.writeLock().lock();
        try {
            T t2 = this.list.set(n2, t);
            return t2;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean setSafe(int n2, T t) {
        this.lock.writeLock().lock();
        try {
            if (n2 >= this.list.size()) {
                boolean bl = false;
                return bl;
            }
            this.list.set(n2, t);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void add(int n2, T t) {
        this.lock.writeLock().lock();
        try {
            this.list.add(n2, t);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean addSafe(int n2, T t) {
        this.lock.writeLock().lock();
        try {
            if (n2 > this.list.size()) {
                boolean bl = false;
                return bl;
            }
            this.list.add(n2, t);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean add(T t) {
        this.lock.writeLock().lock();
        try {
            boolean bl = this.list.add(t);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        this.lock.writeLock().lock();
        try {
            boolean bl = this.list.addAll(collection);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean addAll(int n2, Collection<? extends T> collection) {
        this.lock.writeLock().lock();
        try {
            boolean bl = this.list.addAll(n2, collection);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean contains(Object object) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.list.contains(object);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.list.containsAll(collection);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.list.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean remove(Object object) {
        this.lock.writeLock().lock();
        try {
            boolean bl = this.list.remove(object);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public T remove(int n2) {
        this.lock.writeLock().lock();
        try {
            T t = this.list.remove(n2);
            return t;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean removeSafe(int n2) {
        this.lock.writeLock().lock();
        try {
            if (n2 >= this.list.size()) {
                boolean bl = false;
                return bl;
            }
            this.list.remove(n2);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.lock.writeLock().lock();
        try {
            boolean bl = this.list.removeAll(collection);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        this.lock.writeLock().lock();
        try {
            boolean bl = this.list.retainAll(collection);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int indexOf(Object object) {
        this.lock.readLock().lock();
        try {
            int n2 = this.list.indexOf(object);
            return n2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int lastIndexOf(Object object) {
        this.lock.readLock().lock();
        try {
            int n2 = this.list.lastIndexOf(object);
            return n2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Object[] toArray() {
        this.lock.readLock().lock();
        try {
            Object[] objectArray = this.list.toArray();
            return objectArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public <U> U[] toArray(U[] UArray) {
        this.lock.readLock().lock();
        try {
            U[] UArray2 = this.list.toArray(UArray);
            return UArray2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public List<T> subList(int n2, int n3) {
        this.lock.readLock().lock();
        try {
            ArrayList<T> arrayList = new ArrayList<T>(this.list.subList(n2, n3));
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public ListIterator<T> listIterator() {
        this.lock.readLock().lock();
        try {
            ListIterator<T> listIterator = new ArrayList<T>(this.list).listIterator();
            return listIterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public ListIterator<T> listIterator(int n2) {
        this.lock.readLock().lock();
        try {
            ListIterator<T> listIterator = new ArrayList<T>(this.list.subList(n2, this.list.size())).listIterator();
            return listIterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Iterator<T> iterator() {
        this.lock.readLock().lock();
        try {
            Iterator<T> iterator = new ArrayList<T>(this.list).iterator();
            return iterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    public String toString() {
        return "ConcurrentList@" + this.hashCode();
    }
}

