/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Ser
public class ConcurrentHashSet<E>
implements Set<E> {
    private static Object MOOT_VALUE = new Object();
    @SerId(value=1)
    private ConcurrentHashMap<E, Object> map = new ConcurrentHashMap();

    public ConcurrentHashSet() {
        this.map = new ConcurrentHashMap();
    }

    public ConcurrentHashSet(int n2) {
        this.map = new ConcurrentHashMap(n2);
    }

    public ConcurrentHashSet(Collection<? extends E> collection) {
        this.map = new ConcurrentHashMap(collection.size());
        this.addAll(collection);
    }

    @Override
    public int hashCode() {
        return ((ConcurrentHashMap.KeySetView)this.map.keySet()).hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return ((ConcurrentHashMap.KeySetView)this.map.keySet()).equals(object);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, MOOT_VALUE) == null;
    }

    @Override
    public boolean remove(Object object) {
        return this.map.remove(object) != null;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean bl = false;
        for (E e : collection) {
            bl |= this.add(e);
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            bl |= this.remove(obj);
        }
        return bl;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.map.containsKey(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public Iterator<E> iterator() {
        return ((ConcurrentHashMap.KeySetView)this.map.keySet()).iterator();
    }

    @Override
    public Object[] toArray() {
        return ((ConcurrentHashMap.CollectionView)((Object)this.map.keySet())).toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return ((ConcurrentHashMap.CollectionView)((Object)this.map.keySet())).toArray(TArray);
    }

    public String toString() {
        return ((ConcurrentHashMap.CollectionView)((Object)this.map.keySet())).toString();
    }
}

