/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.collect.IExtractor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CollectionUtil {
    public static boolean containsNull(Iterable<?> iterable) {
        for (Object obj : iterable) {
            if (obj != null) continue;
            return true;
        }
        return false;
    }

    public static boolean containsNonNull(Iterable<?> iterable) {
        for (Object obj : iterable) {
            if (obj == null) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean containsReference(Collection<? extends T> collection, T t) {
        if (collection == null) {
            return false;
        }
        for (T t2 : collection) {
            if (t2 != t) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(Collection<?> collection, Object object) {
        return collection != null && collection.contains(object);
    }

    @Deprecated
    public static <T> List<T> intersection(List<? extends T> list, List<? extends T> list2) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t : list) {
            if (!list2.contains(t)) continue;
            arrayList.add(t);
        }
        return arrayList;
    }

    public static <T> Set<T> intersect(Collection<? extends T> collection, Collection<? extends T> collection2) {
        HashSet<T> hashSet = new HashSet<T>();
        if (collection.isEmpty() || collection2.isEmpty()) {
            return hashSet;
        }
        for (T t : collection) {
            if (!collection2.contains(t)) continue;
            hashSet.add(t);
        }
        return hashSet;
    }

    public static <T> boolean hasIntersection(Collection<? extends T> collection, Collection<? extends T> collection2) {
        if (collection.isEmpty() || collection2.isEmpty()) {
            return false;
        }
        for (T t : collection) {
            if (!collection2.contains(t)) continue;
            return true;
        }
        return false;
    }

    public static <T, K extends Comparable<K>> T binarySearch(List<T> list, K k, IExtractor<T, K> iExtractor) {
        int n2 = CollectionUtil.binarySearchEx(list, k, iExtractor, null);
        return n2 < 0 ? null : (T)list.get(n2);
    }

    public static <T, K extends Comparable<K>> int binarySearchEx(List<? extends T> list, K k, IExtractor<T, ? extends K> iExtractor, Comparator<K> comparator) {
        int n2 = 0;
        int n3 = list.size() - 1;
        while (n2 <= n3) {
            int n4;
            int n5 = n2 + n3 >>> 1;
            Comparable comparable = (Comparable)iExtractor.extract(list.get(n5));
            int n6 = n4 = comparator != null ? comparator.compare(comparable, k) : comparable.compareTo(k);
            if (n4 < 0) {
                n2 = n5 + 1;
                continue;
            }
            if (n4 > 0) {
                n3 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n2 + 1);
    }

    public static <T> boolean compareByReference(Collection<? extends T> collection, Collection<? extends T> collection2, boolean bl) {
        if (collection == null && collection2 == null) {
            return true;
        }
        if (collection == null || collection2 == null) {
            return false;
        }
        if (collection.size() != collection2.size()) {
            return false;
        }
        if (bl) {
            Iterator<T> iterator = collection.iterator();
            Iterator<T> iterator2 = collection2.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() == iterator2.next()) continue;
                return false;
            }
        } else {
            IdentityHashMap identityHashMap = new IdentityHashMap();
            for (T t : collection) {
                identityHashMap.put(t, null);
            }
            for (T t : collection2) {
                if (identityHashMap.containsKey(t)) continue;
                return false;
            }
        }
        return true;
    }

    public static <T> boolean compare(Collection<? extends T> collection, Collection<? extends T> collection2, boolean bl) {
        if (collection == null && collection2 == null) {
            return true;
        }
        if (collection == null || collection2 == null) {
            return false;
        }
        if (collection.size() != collection2.size()) {
            return false;
        }
        if (bl) {
            Iterator<T> iterator = collection.iterator();
            Iterator<T> iterator2 = collection2.iterator();
            while (iterator.hasNext()) {
                T t = iterator.next();
                T t2 = iterator2.next();
                if (t == null && t2 == null || !(t == null && t2 != null || t != null && t2 == null) && (t == null || t.equals(t2))) continue;
                return false;
            }
        } else {
            ArrayList<T> arrayList = new ArrayList<T>(collection2);
            for (T t : collection) {
                int n2 = 0;
                for (Object e : arrayList) {
                    if (t == null && e == null || t != null && t.equals(e)) break;
                    ++n2;
                }
                if (n2 >= arrayList.size()) {
                    return false;
                }
                arrayList.remove(n2);
            }
        }
        return true;
    }

    public static <T> int count(Collection<T> collection, T t) {
        int n2 = 0;
        for (T t2 : collection) {
            if (t2 == null) {
                if (t != null) continue;
                ++n2;
                continue;
            }
            if (!t2.equals(t)) continue;
            ++n2;
        }
        return n2;
    }

    public static <T> int identityCount(Collection<T> collection, T t) {
        int n2 = 0;
        for (T t2 : collection) {
            if (t2 != t) continue;
            ++n2;
        }
        return n2;
    }

    public static <T> Collection<T> addNonNulls(Collection<T> collection, Collection<? extends T> collection2) {
        if (collection2 != null) {
            for (T t : collection2) {
                if (t == null) continue;
                collection.add(t);
            }
        }
        return collection;
    }

    @SafeVarargs
    public static <T> Collection<T> addNonNulls(Collection<T> collection, T ... TArray) {
        if (TArray != null) {
            for (T t : TArray) {
                if (t == null) continue;
                collection.add(t);
            }
        }
        return collection;
    }

    public static <T> Iterable<T> doubleCollectionIterable(final Collection<T> collection, final Collection<T> collection2) {
        if (collection == null || collection2 == null) {
            throw new IllegalArgumentException();
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new DoubleCollIterator(collection, collection2);
            }
        };
    }

    private static class DoubleCollIterator<T>
    implements Iterator<T> {
        private Collection<T> coll1;
        private Collection<T> coll2;
        private Iterator<T> it;

        private DoubleCollIterator(Collection<T> collection, Collection<T> collection2) {
            this.coll1 = collection;
            this.coll2 = collection2;
            this.it = collection.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.coll1 != null) {
                this.it = this.coll1.iterator();
                this.coll1 = null;
                if (this.it.hasNext()) {
                    return true;
                }
                this.it = this.coll2.iterator();
                this.coll2 = null;
                return this.it.hasNext();
            }
            if (this.it.hasNext()) {
                return true;
            }
            if (this.coll2 == null) {
                return false;
            }
            this.it = this.coll2.iterator();
            this.coll2 = null;
            return this.it.hasNext();
        }

        @Override
        public T next() {
            return this.it.next();
        }
    }
}

