/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class CacheMap<K, V> {
    private int maxSize;
    private int evictSize;
    private Map<K, V> map;
    private LinkedHashSet<Object> accesscoll;

    public CacheMap(int n2, int n3, boolean bl) {
        if (n2 <= 0) {
            throw new IllegalArgumentException();
        }
        if (n3 <= 0 || n3 > n2) {
            throw new IllegalArgumentException();
        }
        this.maxSize = n2;
        this.evictSize = n3;
        this.map = bl ? new TreeMap() : new HashMap();
        this.accesscoll = new LinkedHashSet();
    }

    public CacheMap(int n2, int n3) {
        this(n2, n3, false);
    }

    public CacheMap(int n2) {
        this(n2, n2 / 4);
    }

    private void verifyConsistency() {
        if (this.map.size() != this.accesscoll.size()) {
            throw new IllegalStateException("Invalid CacheMap state!");
        }
    }

    private void evict() {
        Iterator iterator = this.accesscoll.iterator();
        for (int i = 0; i < this.evictSize; ++i) {
            if (!iterator.hasNext()) {
                return;
            }
            Object e = iterator.next();
            this.map.remove(e);
            iterator.remove();
        }
    }

    private void accessEntry(Object object) {
        if (!this.accesscoll.add(object)) {
            this.accesscoll.remove(object);
            this.accesscoll.add(object);
        }
    }

    public int size() {
        return this.map.size();
    }

    public synchronized void clear() {
        this.map.clear();
        this.accesscoll.clear();
    }

    public synchronized V put(K k, V v2) {
        if (this.map.size() >= this.maxSize) {
            this.evict();
        }
        this.accessEntry(k);
        return this.map.put(k, v2);
    }

    public synchronized V get(K k) {
        if (!this.accesscoll.contains(k)) {
            return null;
        }
        this.accessEntry(k);
        return this.map.get(k);
    }

    public synchronized boolean containsKey(K k) {
        return this.map.containsKey(k);
    }

    public synchronized V remove(K k) {
        if (this.accesscoll.remove(k)) {
            return this.map.remove(k);
        }
        return null;
    }

    public synchronized void removeRange(K k, K k2) {
        if (!(this.map instanceof TreeMap)) {
            throw new IllegalStateException("removeRange() not supported for unordered CacheMap");
        }
        SortedMap sortedMap = ((TreeMap)this.map).subMap(k, k2);
        this.accesscoll.removeAll(sortedMap.keySet());
        sortedMap.clear();
    }
}

