/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.SerializerHelper;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomInitPostGraph;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomWrite;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;

@Ser
public class CFBytesTrie<T> {
    @SerId(value=1)
    private IKeyExtractor<T> keyExtractor;
    @SerId(value=2)
    private Node[] array0;
    @SerId(value=3)
    private int cnt;
    @SerId(value=4)
    private List<T> valuesForStorage;

    @SerCustomWrite
    private void save(SerializerHelper serializerHelper) throws IOException {
        if (this.keyExtractor == null) {
            serializerHelper.saveStandard();
            return;
        }
        this.valuesForStorage = this.getValues();
        if (this.valuesForStorage.size() != this.cnt) {
            throw new RuntimeException(Strings.ff("Unexpected size: actual=%d, expected=%d", this.valuesForStorage.size(), this.cnt));
        }
        Node[] nodeArray = this.array0;
        this.array0 = null;
        int n2 = this.cnt;
        this.cnt = 0;
        serializerHelper.saveStandard();
        this.valuesForStorage = null;
        this.array0 = nodeArray;
        this.cnt = n2;
    }

    @SerCustomInitPostGraph
    private void postInit() {
        if (this.keyExtractor == null) {
            return;
        }
        for (T t : this.valuesForStorage) {
            this.put(t);
        }
        this.valuesForStorage = null;
    }

    public void setKeyExtractor(IKeyExtractor<T> iKeyExtractor) {
        this.keyExtractor = iKeyExtractor;
    }

    public IKeyExtractor<T> getKeyExtractor() {
        return this.keyExtractor;
    }

    public void clear() {
        this.array0 = null;
        this.cnt = 0;
    }

    public int size() {
        return this.cnt;
    }

    public boolean isEmpty() {
        return this.cnt == 0;
    }

    public void put(T t) {
        if (this.keyExtractor == null) {
            throw new IllegalStateException();
        }
        this.put(this.keyExtractor.extract(t), t);
    }

    public void put(byte[] byArray, T t) {
        this.put(byArray, 0, byArray.length, t);
    }

    public T put(byte[] byArray, int n2, int n3, T t) {
        Node node;
        if (t == null) {
            throw new NullPointerException("The value cannot be null");
        }
        if (n2 >= n3) {
            throw new IllegalArgumentException("Needs at least one byte of key data");
        }
        int n4 = byArray[n2] & 0xFF;
        if (this.array0 == null) {
            this.array0 = new Node[256];
        }
        if ((node = this.array0[n4]) == null) {
            this.array0[n4] = node = new Node();
        }
        for (int i = n2 + 1; i < n3; ++i) {
            Node node2;
            int n5 = byArray[i] & 0xF;
            if (node.next == null) {
                if (node.object != null) {
                    throw new IllegalStateException("Prefix collision");
                }
                node.next = new Node[16];
            }
            if ((node2 = node.next[n5]) == null) {
                node.next[n5] = node2 = new Node();
            }
            node = node2;
            int n6 = byArray[i] >> 4 & 0xF;
            if (node.next == null) {
                if (node.object != null) {
                    throw new IllegalStateException("Prefix collision");
                }
                node.next = new Node[16];
            }
            if ((node2 = node.next[n6]) == null) {
                node.next[n6] = node2 = new Node();
            }
            node = node2;
        }
        if (node.next != null) {
            throw new IllegalStateException("Prefix collision");
        }
        Object object = node.object;
        if (object == null) {
            ++this.cnt;
        }
        node.object = t;
        return (T)object;
    }

    public boolean putSafe(byte[] byArray, int n2, int n3, T t, T[] TArray) {
        try {
            T t2 = this.put(byArray, n2, n3, t);
            if (TArray != null) {
                TArray[0] = t2;
            }
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    public T get(byte[] byArray, boolean bl) {
        return this.get(byArray, 0, byArray.length, bl);
    }

    public T get(byte[] byArray, int n2, int n3, boolean bl) {
        int n4;
        Object object = null;
        if (n2 >= n3) {
            throw new IllegalArgumentException("Needs at least one byte of key data");
        }
        if (this.array0 == null) {
            return null;
        }
        int n5 = byArray[n2] & 0xFF;
        Node node = this.array0[n5];
        if (node == null) {
            return null;
        }
        if (node.object != null) {
            object = node.object;
        }
        if (object == null) {
            for (n4 = n2 + 1; n4 < n3; ++n4) {
                if (node.next == null) {
                    return null;
                }
                int n6 = byArray[n4] & 0xF;
                node = node.next[n6];
                if (node == null) {
                    return null;
                }
                if (node.object != null) {
                    object = node.object;
                    break;
                }
                if (node.next == null) {
                    return null;
                }
                int n7 = byArray[n4] >> 4 & 0xF;
                node = node.next[n7];
                if (node == null) {
                    return null;
                }
                if (node.object == null) continue;
                object = node.object;
                break;
            }
        }
        if (bl && n4 != n3) {
            return null;
        }
        return (T)object;
    }

    public String formatInternalState() {
        State state = new State();
        if (this.array0 != null) {
            state.nodeCount = 1;
            for (Node node : this.array0) {
                this.checkNodeRecurse(node, state, 1);
            }
        }
        Node[] nodeArray = new StringBuilder();
        double d = -1.0;
        if (state.nodeCount > 0) {
            d = (double)state.objectCount / (double)(256 + (state.nodeCount - 1) * 16);
        }
        Strings.ff((Appendable)nodeArray, "cnt=%d nodes=%d depth=%d occupancy=%.3f", state.objectCount, state.nodeCount, state.maxDepth, d);
        return nodeArray.toString();
    }

    private void checkNodeRecurse(Node node, State state, int n2) {
        if (node == null) {
            return;
        }
        if (n2 > state.maxDepth) {
            state.maxDepth = n2;
        }
        if (node.object != null) {
            ++state.objectCount;
        }
        if (node.next != null) {
            ++state.nodeCount;
            for (Node node2 : node.next) {
                this.checkNodeRecurse(node2, state, n2 + 1);
            }
        }
    }

    public List<T> getValues() {
        ArrayList arrayList = new ArrayList();
        if (this.array0 != null) {
            for (Node node : this.array0) {
                this.getValuesRecurse(node, arrayList);
            }
        }
        return arrayList;
    }

    private void getValuesRecurse(Node node, List<T> list) {
        if (node == null) {
            return;
        }
        if (node.object != null) {
            list.add(node.object);
        }
        if (node.next != null) {
            for (Node node2 : node.next) {
                this.getValuesRecurse(node2, list);
            }
        }
    }

    public List<Couple<byte[], T>> getItems() {
        ArrayList<Couple<byte[], T>> arrayList = new ArrayList<Couple<byte[], T>>();
        if (this.array0 != null) {
            ArrayDeque<Byte> arrayDeque = new ArrayDeque<Byte>();
            int n2 = 0;
            for (Node node : this.array0) {
                arrayDeque.push((byte)n2);
                this.getItemsRecurse(node, arrayList, arrayDeque);
                arrayDeque.pop();
                ++n2;
            }
        }
        return arrayList;
    }

    private void getItemsRecurse(Node node, List<Couple<byte[], T>> list, Deque<Byte> deque) {
        if (node == null) {
            return;
        }
        if (node.object != null) {
            list.add(new Couple<byte[], Object>(this.buildKey(deque), node.object));
        }
        if (node.next != null) {
            int n2 = 0;
            for (Node node2 : node.next) {
                deque.push((byte)n2);
                this.getItemsRecurse(node2, list, deque);
                deque.pop();
                ++n2;
            }
        }
    }

    private byte[] buildKey(Deque<Byte> deque) {
        int n2 = deque.size();
        Assert.a(n2 >= 1 && n2 % 2 == 1);
        byte[] byArray = new byte[1 + (n2 - 1) / 2];
        int n3 = 0;
        Iterator<Byte> iterator = deque.descendingIterator();
        int n4 = 1;
        while (iterator.hasNext()) {
            byte by = iterator.next();
            if (n3 == 0) {
                byArray[0] = by;
            } else if (n3 % 2 != 0) {
                byArray[n4] = by;
            } else {
                byArray[n4] = (byte)(byArray[n4] | by << 4);
                ++n4;
            }
            ++n3;
        }
        return byArray;
    }

    static class State {
        int objectCount;
        int nodeCount;
        int maxDepth;

        State() {
        }
    }

    @Ser
    public static class Node {
        @SerId(value=1)
        Node[] next;
        @SerId(value=2)
        Object object;
    }

    @Ser
    public static interface IKeyExtractor<T> {
        public byte[] extract(T var1);
    }
}

