/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.format.Strings;

public class BytePipe {
    private static final int pageSize = 4096;
    private byte[] buffer;
    private volatile int capacity;
    private volatile int position;
    private volatile int limit;
    private Object consumer = new Object();
    private int waitingOn = 0;

    public BytePipe() {
        this(4096);
    }

    public BytePipe(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("Capacity cannot be negative");
        }
        this.capacity = n2;
        this.buffer = new byte[this.capacity];
        this.position = 0;
        this.limit = 0;
    }

    private int round(int n2) {
        return (n2 + 4096 - 1) / 4096 * 4096;
    }

    public int capacity() {
        return this.capacity;
    }

    public int available() {
        return this.limit - this.position;
    }

    public int position() {
        return this.position;
    }

    public int limit() {
        return this.limit;
    }

    public synchronized void reset() {
        this.limit = 0;
        this.position = 0;
    }

    public synchronized void append(byte[] byArray, int n2, int n3) {
        if (this.limit + n3 > this.capacity) {
            int n4 = this.available();
            if (n4 + n3 > this.capacity) {
                int n5 = this.round(2 * (n4 + n3));
                byte[] byArray2 = new byte[n5];
                this.copyBytes(byArray2, 0, this.buffer, this.position, this.limit);
                this.buffer = byArray2;
                this.capacity = n5;
            } else {
                this.copyBytes(this.buffer, 0, this.buffer, this.position, this.limit);
            }
            this.position = 0;
            this.limit = n4;
        }
        this.copyBytes(this.buffer, this.limit, byArray, n2, n2 + n3);
        this.limit += n3;
        this.makeAvailable();
    }

    public synchronized void append(byte[] byArray) {
        this.append(byArray, 0, byArray.length);
    }

    public synchronized void append(byte by) {
        if (this.limit >= this.capacity) {
            int n2 = this.available();
            if (n2 >= this.capacity) {
                int n3 = this.round(2 * (n2 + 1));
                byte[] byArray = new byte[n3];
                this.copyBytes(byArray, 0, this.buffer, this.position, this.limit);
                this.buffer = byArray;
                this.capacity = n3;
            } else {
                this.copyBytes(this.buffer, 0, this.buffer, this.position, this.limit);
            }
            this.position = 0;
            this.limit = n2;
        }
        this.buffer[this.limit] = by;
        ++this.limit;
        this.makeAvailable();
    }

    public synchronized void append(int n2) {
        this.append((byte)n2);
    }

    public synchronized void get(byte[] byArray, int n2, int n3) {
        this.verifyAvailable(n3);
        this.copyBytes(byArray, n2, this.buffer, this.position, this.position + n3);
        this.position += n3;
    }

    public synchronized void get(byte[] byArray) {
        this.get(byArray, 0, byArray.length);
    }

    public synchronized int get() {
        this.verifyAvailable(1);
        return this.buffer[this.position++] & 0xFF;
    }

    public synchronized byte[] getAll() {
        byte[] byArray = new byte[this.available()];
        this.get(byArray);
        return byArray;
    }

    public synchronized void peek(byte[] byArray, int n2, int n3) {
        this.verifyAvailable(n3);
        this.copyBytes(byArray, n2, this.buffer, this.position, this.position + n3);
    }

    public synchronized void peek(byte[] byArray) {
        this.peek(byArray, 0, byArray.length);
    }

    public synchronized byte peek() {
        this.verifyAvailable(1);
        return this.buffer[this.position];
    }

    public synchronized void skip(int n2) {
        this.verifyAvailable(n2);
        this.position += n2;
    }

    private void verifyAvailable(int n2) {
        int n3 = this.available();
        if (n3 < n2) {
            throw new RuntimeException("Not enough bytes are available: requesting " + n2 + ", has only " + n3);
        }
    }

    private void copyBytes(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        if (byArray == byArray2 && n2 >= n3) {
            throw new IllegalArgumentException(Strings.ff("Illegal offsets for idem-buffers: src:%d dst:%d", n3, n2));
        }
        System.arraycopy(byArray2, n3, byArray, n2, n4 - n3);
    }

    public int readWait(long l2) {
        int n2;
        if (this.available() < 1 && (n2 = this.blockUntilAvailable(1, l2)) < 1) {
            return -1;
        }
        return this.get();
    }

    public int blockUntilAvailable(int n2, long l2) {
        if (n2 > 0) {
            Object object = this.consumer;
            synchronized (object) {
                this.waitingOn = n2;
                try {
                    long l3 = System.nanoTime();
                    while (this.available() < this.waitingOn) {
                        long l4;
                        this.consumer.wait(l2);
                        if (l2 == 0L || (l4 = (System.nanoTime() - l3) / 1000000L) < l2) continue;
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {}
                this.waitingOn = 0;
            }
        }
        return this.available();
    }

    private void makeAvailable() {
        Object object = this.consumer;
        synchronized (object) {
            if (this.waitingOn > 0 && this.available() >= this.waitingOn) {
                this.consumer.notify();
            }
        }
    }
}

