/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Ser
public class Bitmap {
    @SerId(value=1)
    private int bitsize;
    @SerId(value=2)
    private long[] array;

    public Bitmap(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("Illegal size for bitmap: " + n2);
        }
        this.bitsize = n2;
        this.array = new long[(n2 + 63) / 64];
    }

    public Bitmap clone() {
        Bitmap bitmap = new Bitmap(this.bitsize);
        System.arraycopy(this.array, 0, bitmap.array, 0, this.array.length);
        return bitmap;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + this.bitsize;
        n2 = 31 * n2 + Arrays.hashCode(this.array);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Bitmap bitmap = (Bitmap)object;
        if (this.bitsize != bitmap.bitsize) {
            return false;
        }
        return Arrays.equals(this.array, bitmap.array);
    }

    public int size() {
        return this.bitsize;
    }

    public int countOnes() {
        int n2 = 0;
        long[] lArray = this.array;
        int n3 = lArray.length;
        for (int i = 0; i < n3; ++i) {
            for (long j = lArray[i]; j != 0L; j >>>= 1) {
                if ((j & 1L) == 0L) continue;
                ++n2;
            }
        }
        return n2;
    }

    public int countZeros() {
        return this.size() - this.countOnes();
    }

    public void clear() {
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = 0L;
        }
    }

    public boolean set(int n2, boolean bl) {
        boolean bl2;
        if (n2 < 0 || n2 >= this.bitsize) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        long l2 = this.array[n2 >> 6];
        long l3 = 1L << (int)((long)n2 & 0x3FL);
        boolean bl3 = bl2 = (l2 & l3) != 0L;
        if (!(bl2 ^ bl)) {
            return false;
        }
        this.array[n2 >> 6] = bl ? l2 | l3 : l2 & (l3 ^ 0xFFFFFFFFFFFFFFFFL);
        return true;
    }

    public void set(int n2) {
        if (n2 < 0 || n2 >= this.bitsize) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        int n3 = n2 >> 6;
        this.array[n3] = this.array[n3] | 1L << (int)((long)n2 & 0x3FL);
    }

    public void setRange(int n2, int n3) {
        for (int i = n2; i < n3; ++i) {
            this.set(i);
        }
    }

    public void reset(int n2) {
        if (n2 < 0 || n2 >= this.bitsize) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        int n3 = n2 >> 6;
        this.array[n3] = this.array[n3] & (1L << (int)((long)n2 & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public boolean get(int n2) {
        if (n2 < 0 || n2 >= this.bitsize) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        return (this.array[n2 >> 6] & 1L << (int)((long)n2 & 0x3FL)) != 0L;
    }

    public void addAllFrom(Bitmap bitmap) {
        if (this.bitsize != bitmap.bitsize) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.array.length; ++i) {
            int n2 = i;
            this.array[n2] = this.array[n2] | bitmap.array[i];
        }
    }

    public void removeAllFrom(Bitmap bitmap) {
        if (this.bitsize != bitmap.bitsize) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.array.length; ++i) {
            int n2 = i;
            this.array[n2] = this.array[n2] & (bitmap.array[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public boolean isFull() {
        int n2 = this.bitsize & 0x3F;
        if (n2 == 0) {
            for (int i = 0; i < this.array.length; ++i) {
                if (this.array[i] == -1L) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < this.array.length - 1; ++i) {
            if (this.array[i] == -1L) continue;
            return false;
        }
        long l2 = this.array[this.array.length - 1];
        long l3 = (1L << n2) - 1L;
        return l2 == l3;
    }

    public boolean isEmpty() {
        for (long l2 : this.array) {
            if (l2 == 0L) continue;
            return false;
        }
        return true;
    }

    public List<Integer> ones() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = 0;
        for (long l2 : this.array) {
            int n3 = n2 << 6;
            while (l2 != 0L) {
                if ((l2 & 1L) != 0L) {
                    arrayList.add(n3);
                }
                l2 >>>= 1;
                ++n3;
            }
            ++n2;
        }
        return arrayList;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.bitsize; ++i) {
            stringBuilder.append(this.get(i) ? "1" : "0");
        }
        return stringBuilder.toString();
    }

    public String formatAsRanges() {
        return this.formatAsRanges(true);
    }

    public String formatAsRanges(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = -1;
        for (int i = 0; i < this.bitsize; ++i) {
            boolean bl2 = this.get(i);
            if (n2 < 0 && bl2) {
                n2 = i;
                continue;
            }
            if (n2 < 0 || bl2) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append("U");
            }
            if (n2 + 1 == i) {
                Strings.ff(stringBuilder, "[%d]", n2);
            } else if (bl) {
                Strings.ff(stringBuilder, "[%d,%d)", n2, i);
            } else {
                Strings.ff(stringBuilder, "[%d,%d]", n2, i - 1);
            }
            n2 = -1;
        }
        if (stringBuilder.length() == 0) {
            return "[]";
        }
        return stringBuilder.toString();
    }
}

