/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.collect.CollectionOrder;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

@Ser
public class BiMap<K, V> {
    @SerId(value=1)
    private Map<K, V> map;
    @SerId(value=2)
    private Map<V, K> rmap;

    public BiMap() {
        this(CollectionOrder.NONE);
    }

    public BiMap(CollectionOrder collectionOrder) {
        if (collectionOrder == null) {
            throw new NullPointerException("Illegal key order");
        }
        switch (collectionOrder) {
            case NONE: {
                this.map = new HashMap();
                this.rmap = new HashMap<V, K>();
                break;
            }
            case INSERTION: {
                this.map = new LinkedHashMap();
                this.rmap = new LinkedHashMap<V, K>();
                break;
            }
            case NATURAL: {
                this.map = new TreeMap();
                this.rmap = new TreeMap<V, K>();
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    public void clear() {
        this.map.clear();
        this.rmap.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        int n2 = this.map.size();
        if (this.rmap.size() != n2) {
            throw new IllegalStateException();
        }
        return n2;
    }

    public V put(K k, V v2) {
        K k2;
        if (k == null) {
            throw new IllegalArgumentException("Illegal null key");
        }
        if (v2 == null) {
            throw new IllegalArgumentException("Illegal null key");
        }
        V v3 = this.map.put(k, v2);
        if (v3 != null) {
            this.rmap.remove(v3);
        }
        if ((k2 = this.rmap.put(v2, k)) != null) {
            this.map.remove(k2);
        }
        return v3;
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public boolean containsKey(K k) {
        return this.map.containsKey(k);
    }

    public boolean containsValue(V v2) {
        return this.rmap.containsKey(v2);
    }

    public V get(K k) {
        return this.map.get(k);
    }

    public K getKeyForValue(V v2) {
        return this.rmap.get(v2);
    }

    public V remove(K k) {
        V v2 = this.map.remove(k);
        if (v2 != null) {
            this.rmap.remove(v2);
        }
        return v2;
    }

    public K removeValue(V v2) {
        K k = this.rmap.remove(v2);
        if (k != null) {
            this.map.remove(k);
        }
        return k;
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public Set<V> values() {
        return this.rmap.keySet();
    }

    public Map<K, V> asMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public Map<V, K> asReverseMap() {
        return Collections.unmodifiableMap(this.rmap);
    }

    public String toString() {
        return this.map.toString();
    }
}

