/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

@Ser
public class AsyncEventQueue<E> {
    @SerId(value=1)
    private ConcurrentLinkedQueue<E> q = new ConcurrentLinkedQueue();
    @SerId(value=2)
    private int capacity;

    public AsyncEventQueue() {
        this(Integer.MAX_VALUE);
    }

    public AsyncEventQueue(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("Capacity must be positive");
        }
        this.capacity = n2;
    }

    public boolean add(E e) {
        if (e == null) {
            throw new IllegalArgumentException();
        }
        if (this.q.size() > this.capacity) {
            return false;
        }
        this.q.add(e);
        return true;
    }

    public E pull() {
        if (this.q.isEmpty()) {
            return null;
        }
        return this.q.remove();
    }

    public List<E> pullAll() {
        ArrayList<E> arrayList = new ArrayList<E>(this.q);
        this.q.clear();
        return arrayList;
    }

    public List<E> readAll() {
        return new ArrayList<E>(this.q);
    }

    public int size() {
        return this.q.size();
    }

    public boolean isEmpty() {
        return this.q.isEmpty();
    }

    public void clear() {
        this.q.clear();
    }

    public String toString() {
        return this.q.toString();
    }
}

