/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.format.Strings;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public class ArrayUtil {
    public static final Object[] NO_OBJECT = new Object[0];
    public static final String[] NO_STRING = new String[0];
    public static final boolean[] NO_BOOLEAN = new boolean[0];
    public static final byte[] NO_BYTE = new byte[0];
    public static final char[] NO_CHAR = new char[0];
    public static final short[] NO_SHORT = new short[0];
    public static final int[] NO_INT = new int[0];
    public static final long[] NO_LONG = new long[0];
    public static final float[] NO_FLOAT = new float[0];
    public static final double[] NO_DOUBLE = new double[0];

    public static void copyBytes(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        System.arraycopy(byArray2, n3, byArray, n2, n4);
    }

    public static int[] bytesToIntegers(byte[] byArray) {
        int[] nArray = new int[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            nArray[i] = byArray[i];
        }
        return nArray;
    }

    public static int[] unsignedBytesToIntegers(byte[] byArray) {
        int[] nArray = new int[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            nArray[i] = byArray[i] & 0xFF;
        }
        return nArray;
    }

    public static byte[] integersToBytes(int[] nArray) {
        byte[] byArray = new byte[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i] = (byte)nArray[i];
        }
        return byArray;
    }

    public static boolean isSled(byte[] byArray, byte by) {
        for (byte by2 : byArray) {
            if (by2 == by) continue;
            return false;
        }
        return true;
    }

    public static int compareBytes(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        int n5 = n2 + n4;
        while (n2 < n5) {
            int n6 = byArray[n2] - byArray2[n3];
            if (n6 != 0) {
                return n6 > 0 ? 1 : -1;
            }
            ++n2;
            ++n3;
        }
        return 0;
    }

    public static boolean equalsBytes(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        if (n2 < 0 || n2 + n4 > byArray.length) {
            return false;
        }
        if (n3 < 0 || n3 + n4 > byArray2.length) {
            return false;
        }
        return ArrayUtil.compareBytes(byArray, n2, byArray2, n3, n4) == 0;
    }

    public static List<Boolean> asList(boolean[] blArray) {
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>(blArray.length);
        for (int i = 0; i < blArray.length; ++i) {
            arrayList.add(blArray[i]);
        }
        return arrayList;
    }

    public static List<Byte> asList(byte[] byArray) {
        ArrayList<Byte> arrayList = new ArrayList<Byte>(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            arrayList.add(byArray[i]);
        }
        return arrayList;
    }

    public static List<Short> asList(short[] sArray) {
        ArrayList<Short> arrayList = new ArrayList<Short>(sArray.length);
        for (int i = 0; i < sArray.length; ++i) {
            arrayList.add(sArray[i]);
        }
        return arrayList;
    }

    public static List<Character> asList(char[] cArray) {
        ArrayList<Character> arrayList = new ArrayList<Character>(cArray.length);
        for (int i = 0; i < cArray.length; ++i) {
            arrayList.add(Character.valueOf(cArray[i]));
        }
        return arrayList;
    }

    public static List<Integer> asList(int[] nArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(nArray[i]);
        }
        return arrayList;
    }

    public static List<Long> asList(long[] lArray) {
        ArrayList<Long> arrayList = new ArrayList<Long>(lArray.length);
        for (int i = 0; i < lArray.length; ++i) {
            arrayList.add(lArray[i]);
        }
        return arrayList;
    }

    public static List<Float> asList(float[] fArray) {
        ArrayList<Float> arrayList = new ArrayList<Float>(fArray.length);
        for (int i = 0; i < fArray.length; ++i) {
            arrayList.add(Float.valueOf(fArray[i]));
        }
        return arrayList;
    }

    public static List<Double> asList(double[] dArray) {
        ArrayList<Double> arrayList = new ArrayList<Double>(dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            arrayList.add(dArray[i]);
        }
        return arrayList;
    }

    public static void swap(boolean[] blArray, int n2, int n3) {
        int n4 = n2;
        for (int i = n2 + n3 - 1; n4 < i; ++n4, --i) {
            boolean bl = blArray[n4];
            blArray[n4] = blArray[i];
            blArray[i] = bl;
        }
    }

    public static void swap(boolean[] blArray) {
        ArrayUtil.swap(blArray, 0, blArray.length);
    }

    public static void swap(byte[] byArray, int n2, int n3) {
        int n4 = n2;
        for (int i = n2 + n3 - 1; n4 < i; ++n4, --i) {
            byte by = byArray[n4];
            byArray[n4] = byArray[i];
            byArray[i] = by;
        }
    }

    public static void swap(byte[] byArray) {
        ArrayUtil.swap(byArray, 0, byArray.length);
    }

    public static void swap(short[] sArray, int n2, int n3) {
        int n4 = n2;
        for (int i = n2 + n3 - 1; n4 < i; ++n4, --i) {
            short s2 = sArray[n4];
            sArray[n4] = sArray[i];
            sArray[i] = s2;
        }
    }

    public static void swap(short[] sArray) {
        ArrayUtil.swap(sArray, 0, sArray.length);
    }

    public static void swap(char[] cArray, int n2, int n3) {
        int n4 = n2;
        for (int i = n2 + n3 - 1; n4 < i; ++n4, --i) {
            char c2 = cArray[n4];
            cArray[n4] = cArray[i];
            cArray[i] = c2;
        }
    }

    public static void swap(char[] cArray) {
        ArrayUtil.swap(cArray, 0, cArray.length);
    }

    public static void swap(int[] nArray, int n2, int n3) {
        int n4 = n2;
        for (int i = n2 + n3 - 1; n4 < i; ++n4, --i) {
            int n5 = nArray[n4];
            nArray[n4] = nArray[i];
            nArray[i] = n5;
        }
    }

    public static void swap(int[] nArray) {
        ArrayUtil.swap(nArray, 0, nArray.length);
    }

    public static void swap(long[] lArray, int n2, int n3) {
        int n4 = n2;
        for (int i = n2 + n3 - 1; n4 < i; ++n4, --i) {
            long l2 = lArray[n4];
            lArray[n4] = lArray[i];
            lArray[i] = l2;
        }
    }

    public static void swap(long[] lArray) {
        ArrayUtil.swap(lArray, 0, lArray.length);
    }

    public static void swap(float[] fArray, int n2, int n3) {
        int n4 = n2;
        for (int i = n2 + n3 - 1; n4 < i; ++n4, --i) {
            float f = fArray[n4];
            fArray[n4] = fArray[i];
            fArray[i] = f;
        }
    }

    public static void swap(float[] fArray) {
        ArrayUtil.swap(fArray, 0, fArray.length);
    }

    public static void swap(double[] dArray, int n2, int n3) {
        int n4 = n2;
        for (int i = n2 + n3 - 1; n4 < i; ++n4, --i) {
            double d = dArray[n4];
            dArray[n4] = dArray[i];
            dArray[i] = d;
        }
    }

    public static void swap(double[] dArray) {
        ArrayUtil.swap(dArray, 0, dArray.length);
    }

    public static <T> void swap(T[] TArray, int n2, int n3) {
        int n4 = n2;
        for (int i = n2 + n3 - 1; n4 < i; ++n4, --i) {
            T t = TArray[n4];
            TArray[n4] = TArray[i];
            TArray[i] = t;
        }
    }

    public static <T> void swap(T[] TArray) {
        ArrayUtil.swap(TArray, 0, TArray.length);
    }

    public static int find(boolean[] blArray, boolean bl) {
        for (int i = 0; i < blArray.length; ++i) {
            if (blArray[i] != bl) continue;
            return i;
        }
        return -1;
    }

    public static int find(byte[] byArray, byte by) {
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != by) continue;
            return i;
        }
        return -1;
    }

    public static int find(char[] cArray, char c2) {
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != c2) continue;
            return i;
        }
        return -1;
    }

    public static int find(short[] sArray, short s2) {
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] != s2) continue;
            return i;
        }
        return -1;
    }

    public static int find(int[] nArray, int n2) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n2) continue;
            return i;
        }
        return -1;
    }

    public static int find(long[] lArray, long l2) {
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] != l2) continue;
            return i;
        }
        return -1;
    }

    public static int find(float[] fArray, float f) {
        for (int i = 0; i < fArray.length; ++i) {
            if (fArray[i] != f) continue;
            return i;
        }
        return -1;
    }

    public static int find(double[] dArray, double d) {
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] != d) continue;
            return i;
        }
        return -1;
    }

    public static int findByReference(Object[] objectArray, Object object) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != object) continue;
            return i;
        }
        return -1;
    }

    public static int findByEquality(Object[] objectArray, Object object) {
        for (int i = 0; i < objectArray.length; ++i) {
            if ((object != null || objectArray[i] != null) && (object == null || !object.equals(objectArray[i]))) continue;
            return i;
        }
        return -1;
    }

    public static void checkOffsetAndCount(int n2, int n3, int n4) {
        if (n3 < 0 || n4 < 0 || n3 > n2 || n3 + n4 > n2) {
            throw new ArrayIndexOutOfBoundsException(Strings.ff("An array of length %d cannot accommodate a sub-range [%d,%d)", n2, n3, n3 + n4));
        }
    }

    public static <T> T getSafe(T[] TArray, int n2, T t) {
        if (n2 < 0 || n2 >= TArray.length || TArray[n2] == null) {
            return t;
        }
        return TArray[n2];
    }

    public static <T> T getSafe2(T[][] TArray, int n2, int n3, T t) {
        if (n2 < 0 || n2 >= TArray.length || TArray[n2] == null) {
            return t;
        }
        return ArrayUtil.getSafe(TArray[n2], n3, t);
    }

    public static <T> T getSafe3(T[][][] TArray, int n2, int n3, int n4, T t) {
        if (n2 < 0 || n2 >= TArray.length || TArray[n2] == null) {
            return t;
        }
        return ArrayUtil.getSafe2(TArray[n2], n3, n4, t);
    }

    public static <T> List<T> asView(T[] TArray) {
        return new OneArrayAsList<T>(TArray);
    }

    public static <T> List<T> asView(T[] TArray, T[] TArray2) {
        return new TwoArraysAsList<T>(TArray, TArray2);
    }

    @SafeVarargs
    public static <T> List<T> asView(T[] ... TArray) {
        return new MultiArraysAsList<T>(TArray);
    }

    private static class MultiArraysAsList<T>
    extends AbstractList<T> {
        T[][] arrays;

        MultiArraysAsList(T[][] TArray) {
            this.arrays = TArray;
        }

        @Override
        public int size() {
            int n2 = 0;
            for (T[] TArray : this.arrays) {
                n2 += TArray.length;
            }
            return n2;
        }

        @Override
        public T get(int n2) {
            if (n2 < 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            for (T[] TArray : this.arrays) {
                if (n2 < TArray.length) {
                    return TArray[n2];
                }
                n2 -= TArray.length;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    private static class TwoArraysAsList<T>
    extends AbstractList<T> {
        T[] a;
        T[] b;

        TwoArraysAsList(T[] TArray, T[] TArray2) {
            this.a = TArray;
            this.b = TArray2;
        }

        @Override
        public int size() {
            return this.a.length + this.b.length;
        }

        @Override
        public T get(int n2) {
            if (n2 < 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (n2 < this.a.length) {
                return this.a[n2];
            }
            if ((n2 -= this.a.length) < this.b.length) {
                return this.b[n2];
            }
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    private static class OneArrayAsList<T>
    extends AbstractList<T> {
        T[] a;

        OneArrayAsList(T[] TArray) {
            this.a = TArray;
        }

        @Override
        public int size() {
            return this.a.length;
        }

        @Override
        public T get(int n2) {
            if (n2 < 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (n2 < this.a.length) {
                return this.a[n2];
            }
            throw new ArrayIndexOutOfBoundsException();
        }
    }
}

