/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.collect.ISegment;
import com.pnfsoftware.jeb.util.collect.SegmentMap;
import com.pnfsoftware.jeb.util.math.MathUtil;
import com.pnfsoftware.jeb.util.primitives.Longs;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerConstructor;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.Comparator;

@Ser
public final class AddressSegmentMap<T extends ISegment<Long>>
extends SegmentMap<Long, T> {
    private static final long serialVersionUID = 1L;
    @SerId(value=1)
    private long invmask;
    @SerId(value=2)
    private long overflow;

    @SerConstructor
    private AddressSegmentMap() {
        this(1);
    }

    public AddressSegmentMap(int n2) {
        super(new Comparator<Long>(){

            @Override
            public int compare(Long l2, Long l3) {
                return Longs.compareUnsigned(l2, l3);
            }
        });
        if (n2 <= 0 || n2 > 64) {
            throw new IllegalArgumentException();
        }
        this.invmask = MathUtil.makeInverseMask(n2);
        this.overflow = MathUtil.makeOverflow(n2);
    }

    @Override
    public final boolean isValidKey(Long l2) {
        long l3 = l2;
        return (l3 & this.invmask) == 0L || l3 == this.overflow;
    }
}

