/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.math.MathUtil;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerConstructor;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.concurrent.ConcurrentHashMap;

@Ser
public class AddressHashMap<V>
extends ConcurrentHashMap<Long, V> {
    private static final long serialVersionUID = 1L;
    @SerId(value=1)
    private long invmask;

    @SerConstructor
    private AddressHashMap() {
        this(1);
    }

    public AddressHashMap(int n2) {
        if (n2 <= 0 || n2 > 64) {
            throw new IllegalArgumentException();
        }
        this.invmask = MathUtil.makeInverseMask(n2);
    }

    @Override
    public V put(Long l2, V v2) {
        if ((l2 & this.invmask) != 0L) {
            throw new IllegalArgumentException(Strings.ff("Illegal address: 0x%X", l2));
        }
        return super.put(l2, v2);
    }
}

