/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.base;

import com.pnfsoftware.jeb.util.format.Formatter;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Throwables {
    public static String formatStacktraceAlt(Throwable throwable) {
        return new ThrowableFormatter(true).format(throwable);
    }

    public static String formatStacktrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return ((Object)stringWriter).toString();
    }

    public static String formatStacktraceShort(Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder("EXCEPTION: ");
        while (true) {
            stringBuilder.append(throwable.toString());
            if (throwable.getStackTrace().length > 0) {
                stringBuilder.append(" in " + throwable.getStackTrace()[0]);
            }
            if ((throwable = throwable.getCause()) == null) break;
            stringBuilder.append(" / caused by: ");
        }
        return stringBuilder.toString();
    }

    public static void rethrowUnchecked(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new RuntimeException(throwable);
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable throwable2;
        while ((throwable2 = throwable.getCause()) != null) {
            throwable = throwable2;
        }
        return throwable;
    }

    public static class ThrowableFormatter {
        private boolean escapeTokens;
        private StringBuilder sb;
        private int depth;

        public ThrowableFormatter(boolean bl) {
            this.escapeTokens = bl;
        }

        public String format(Throwable throwable) {
            this.sb = new StringBuilder();
            this.depth = 0;
            this.formatRecurse(throwable);
            return this.sb.toString();
        }

        private void formatRecurse(Throwable throwable) {
            if (this.depth > 50) {
                this.sb.append("[FORMATTING STOPPED, STACKTRACE IS TOO LARGE]");
                return;
            }
            ++this.depth;
            this.app(throwable.getClass().getName());
            this.sb.append(":");
            String string = throwable.getMessage();
            if (string != null) {
                this.sb.append(" ");
                this.app(string);
            }
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                this.sb.append("\n    at ");
                StackTraceElement stackTraceElement = stackTraceElementArray[i];
                this.app(stackTraceElement.getClassName());
                this.sb.append(".");
                this.app(stackTraceElement.getMethodName());
                this.sb.append("(");
                this.app(stackTraceElement.getFileName());
                this.sb.append(":");
                this.sb.append(stackTraceElement.getLineNumber());
                this.sb.append(")");
            }
            Throwable throwable2 = throwable.getCause();
            if (throwable2 != null) {
                this.sb.append("\nCaused by: ");
                this.formatRecurse(throwable2);
            }
            --this.depth;
        }

        private void app(String string) {
            if (this.escapeTokens) {
                string = Formatter.escapeString(string, false);
            }
            this.sb.append(string);
        }
    }
}

