/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.base;

import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;

public class SystemUtil {
    private static final ILogger logger = GlobalLog.getLogger(SystemUtil.class);
    public static final String javavendor = System.getProperty("java.vendor");
    public static final String javaversion = System.getProperty("java.version");
    public static final String javaspecversion = System.getProperty("java.specification.version");
    public static final String osname = System.getProperty("os.name");
    public static final String osarch = System.getProperty("os.arch");
    public static final String osversion = System.getProperty("os.version");

    public static String getJavaVendor() {
        return javavendor;
    }

    public static String getJavaVersion() {
        return javaversion;
    }

    public static String getJavaSpecificationVersion() {
        return javaspecversion;
    }

    public static String getOsName() {
        return osname;
    }

    public static String getOsArchitecture() {
        return osarch;
    }

    public static String getOsVersion() {
        return osversion;
    }

    public static int getMajorJavaVersion() {
        int n2 = SystemUtil.parseMajorJavaVersion(javaspecversion);
        if (n2 == 0 && (n2 = SystemUtil.parseMajorJavaVersion(javaversion)) == 0) {
            logger.warn("Unsupported Java version string: \"%s\"", javaversion);
        }
        return n2;
    }

    public static int parseMajorJavaVersion(String string) {
        int n2;
        String string2 = string.trim();
        if (string2.startsWith("1.")) {
            string2 = string2.substring(2);
        }
        if ((n2 = string2.indexOf(46)) >= 0) {
            string2 = string2.substring(0, n2);
        }
        if ((n2 = string2.indexOf(45)) >= 0) {
            string2 = string2.substring(0, n2);
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

