/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.base;

import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.base.IStringMatcher;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StarMatcher
implements IStringMatcher {
    private boolean ci;
    private List<E> bits;
    private int charSearchLength;

    public StarMatcher(String string, boolean bl, boolean bl2) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.ci = bl;
        if (bl) {
            string = string.toLowerCase();
        }
        this.bits = new ArrayList<E>();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (bl2 && c2 == '\\') {
                if (i + 1 >= string.length()) continue;
                if ((c2 = string.charAt(++i)) == '\\' || c2 == '\'' || c2 == '\"' || c2 == '*' || c2 == '?') {
                    stringBuilder.append(c2);
                    continue;
                }
                if (c2 == 'n') {
                    stringBuilder.append('\n');
                    continue;
                }
                if (c2 == 'r') {
                    stringBuilder.append('\r');
                    continue;
                }
                if (c2 == 't') {
                    stringBuilder.append('\t');
                    continue;
                }
                stringBuilder.append('\\').append(c2);
                continue;
            }
            if (c2 == '?') {
                if (stringBuilder.length() > 0) {
                    this.bits.add(new E(stringBuilder.toString()));
                    stringBuilder.setLength(0);
                }
                if (this.bits.isEmpty()) continue;
                this.bits.add(E.ANY);
                continue;
            }
            if (c2 == '*') {
                if (stringBuilder.length() > 0) {
                    this.bits.add(new E(stringBuilder.toString()));
                    stringBuilder.setLength(0);
                }
                if (this.bits.isEmpty() || this.bits.get(this.bits.size() - 1) == E.STAR) continue;
                this.bits.add(E.STAR);
                continue;
            }
            stringBuilder.append(c2);
        }
        if (stringBuilder.length() > 0) {
            this.bits.add(new E(stringBuilder.toString()));
        }
        for (E e : this.bits) {
            this.charSearchLength += e.length();
        }
    }

    public StarMatcher(String string) {
        this(string, true, true);
    }

    public int getCharSearchLength() {
        return this.charSearchLength;
    }

    @Override
    public boolean matches(String string) {
        return this.find(string, 0) != null;
    }

    public Collection<String> collect(Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : collection) {
            if (!this.matches(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public Result find(String string, int n2) {
        if (string == null) {
            return null;
        }
        ArrayDeque<Couple<Integer, Integer>> arrayDeque = new ArrayDeque<Couple<Integer, Integer>>();
        int n3 = n2;
        boolean bl = false;
        int n4 = n3;
        int n5 = 0;
        while (n5 < this.bits.size()) {
            E e = this.bits.get(n5);
            if (e == E.STAR) {
                bl = false;
            } else if (e != E.ANY) {
                if (bl) {
                    if (!string.regionMatches(this.ci, n4, e.str, 0, e.str.length())) {
                        n4 = -1;
                    }
                } else if ((n4 = this.indexOf(string, e.str, n4)) >= 0) {
                    arrayDeque.push(new Couple<Integer, Integer>(n5, n4));
                    bl = true;
                }
                if (n4 < 0) {
                    if (arrayDeque.isEmpty()) {
                        return null;
                    }
                    Couple couple = (Couple)arrayDeque.pop();
                    n5 = (Integer)couple.getFirst();
                    n4 = (Integer)couple.getSecond() + 1;
                    bl = false;
                    continue;
                }
            }
            if (n5 == 0) {
                n3 = n4;
            }
            n4 += e.length();
            ++n5;
        }
        return new Result(n3, n4);
    }

    private int indexOf(String string, String string2, int n2) {
        if (string2.length() == 0) {
            return n2;
        }
        if (!this.ci) {
            return string.indexOf(string2, n2);
        }
        block0: for (int i = n2; i <= string.length() - string2.length(); ++i) {
            if (Character.toLowerCase(string.charAt(i)) != string2.charAt(0)) continue;
            for (int j = 1; j < string2.length(); ++j) {
                if (Character.toLowerCase(string.charAt(i + j)) != string2.charAt(j)) continue block0;
            }
            return i;
        }
        return -1;
    }

    static class LineResult {
        public int charStartIndex;
        public int charEndIndex;
        public int lineStartIndex;
        public int lineEndIndex;

        public LineResult(int n2, int n3, int n4, int n5) {
            this.charStartIndex = n2;
            this.charEndIndex = n3;
            this.lineStartIndex = n4;
            this.lineEndIndex = n5;
        }

        public int hashCode() {
            int n2 = 1;
            n2 = 31 * n2 + this.charEndIndex;
            n2 = 31 * n2 + this.charStartIndex;
            n2 = 31 * n2 + this.lineEndIndex;
            n2 = 31 * n2 + this.lineStartIndex;
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            LineResult lineResult = (LineResult)object;
            if (this.charEndIndex != lineResult.charEndIndex) {
                return false;
            }
            if (this.charStartIndex != lineResult.charStartIndex) {
                return false;
            }
            if (this.lineEndIndex != lineResult.lineEndIndex) {
                return false;
            }
            return this.lineStartIndex == lineResult.lineStartIndex;
        }

        public String toString() {
            return Strings.ff("Found: %d,%d (line: %d,%d)", this.charStartIndex, this.charEndIndex, this.lineStartIndex, this.lineEndIndex);
        }
    }

    public static class Result {
        public int charStartIndex;
        public int charEndIndex;

        public Result(int n2, int n3) {
            this.charStartIndex = n2;
            this.charEndIndex = n3;
        }

        public int hashCode() {
            int n2 = 1;
            n2 = 31 * n2 + this.charEndIndex;
            n2 = 31 * n2 + this.charStartIndex;
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Result result = (Result)object;
            if (this.charEndIndex != result.charEndIndex) {
                return false;
            }
            return this.charStartIndex == result.charStartIndex;
        }

        public String toString() {
            return Strings.ff("Found: %d,%d", this.charStartIndex, this.charEndIndex);
        }
    }

    static class E {
        static final E ANY = new E(1);
        static final E STAR = new E(2);
        final int type;
        final String str;

        E(String string) {
            Assert.a(string != null && string.length() > 0);
            this.type = 0;
            this.str = string;
        }

        E(int n2) {
            Assert.a(n2 != 0);
            this.type = n2;
            this.str = null;
        }

        boolean isString() {
            return this.type == 0;
        }

        int length() {
            if (this.type == 1) {
                return 1;
            }
            if (this.type == 2) {
                return 0;
            }
            return this.str.length();
        }

        public String toString() {
            if (this.type == 0) {
                return this.str;
            }
            if (this.type == 1) {
                return "?";
            }
            if (this.type == 2) {
                return "*";
            }
            throw new RuntimeException();
        }
    }
}

