/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.base;

import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.Map;

public class Stacktraces {
    public static String getCallerString(String ... stringArray) {
        return Stacktraces.getCallerString(null, stringArray);
    }

    public static String getCallerString(StackTraceElement[] stackTraceElementArray, String ... stringArray) {
        Object object;
        int n2;
        if (stringArray.length == 0) {
            return null;
        }
        if (stackTraceElementArray == null) {
            stackTraceElementArray = Thread.currentThread().getStackTrace();
        }
        boolean bl = false;
        for (n2 = 0; n2 < stackTraceElementArray.length; ++n2) {
            object = stackTraceElementArray[n2].getClassName();
            if (Strings.startsWith((String)object, stringArray)) {
                bl = true;
                continue;
            }
            if (bl) break;
        }
        if (n2 >= stackTraceElementArray.length) {
            return null;
        }
        object = stackTraceElementArray[n2];
        String string = ((StackTraceElement)object).getClassName();
        int n3 = string.lastIndexOf(46);
        String string2 = n3 < 0 ? string : string.substring(n3 + 1);
        String string3 = ((StackTraceElement)object).getMethodName();
        int n4 = ((StackTraceElement)object).getLineNumber();
        return Strings.ff("%s.%s:%d", string2, string3, n4);
    }

    public static String formatCallerOriginString(StackTraceElement[] stackTraceElementArray) {
        if (stackTraceElementArray == null) {
            stackTraceElementArray = Thread.currentThread().getStackTrace();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            String string = stackTraceElement.getClassName();
            int n2 = string.lastIndexOf(46);
            String string2 = n2 < 0 ? string : string.substring(n2 + 1);
            String string3 = stackTraceElement.getMethodName();
            int n3 = stackTraceElement.getLineNumber();
            Strings.ff(stringBuilder, "%s.%s:%d < ", string2, string3, n3);
        }
        return stringBuilder.toString();
    }

    public static String formatThreadStacktraces() {
        return Stacktraces.formatThreadStacktraces(false, false);
    }

    public static String formatThreadStacktraces(boolean bl, boolean bl2) {
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        ArrayList<Thread> arrayList = new ArrayList<Thread>(map.keySet());
        arrayList.sort((thread, thread2) -> Long.compare(thread.getId(), thread2.getId()));
        Thread thread3 = Thread.currentThread();
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (Thread thread4 : arrayList) {
            if (thread4 == thread3 && bl) continue;
            if (!thread4.isAlive()) {
                if (!bl2) continue;
                stringBuilder.append("Dead ");
            }
            Strings.ff(stringBuilder, "Thread '%s' (%d)", thread4.getName(), thread4.getId());
            if (thread4.isInterrupted()) {
                stringBuilder.append(" [INTERRUPTED]");
            }
            Stacktraces.formatStacktrace(stringBuilder, map.get(thread4));
            stringBuilder.append('\n');
            ++n2;
        }
        stringBuilder.insert(0, n2 + " threads:\n");
        return stringBuilder.toString();
    }

    private static void formatStacktrace(StringBuilder stringBuilder, StackTraceElement[] stackTraceElementArray) {
        if (stackTraceElementArray == null || stackTraceElementArray.length == 0) {
            return;
        }
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            stringBuilder.append("\n    ");
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            stringBuilder.append(stackTraceElement.getClassName());
            stringBuilder.append(".");
            stringBuilder.append(stackTraceElement.getMethodName());
            stringBuilder.append("(");
            stringBuilder.append(stackTraceElement.getFileName());
            stringBuilder.append(":");
            stringBuilder.append(stackTraceElement.getLineNumber());
            stringBuilder.append(")");
        }
    }
}

