/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.base;

import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class IniFileEditor {
    private static final ILogger logger = GlobalLog.getLogger(IniFileEditor.class);
    File file;
    Character cc;
    List<String> lines;

    public IniFileEditor(File file, Character c2) throws IOException {
        this.file = file;
        this.cc = c2;
        this.lines = IO.readLines(file, Charset.defaultCharset());
    }

    public IniFileEditor(File file) throws IOException {
        this(file, null);
    }

    public IniFileEditor(String string, Character c2) {
        this.file = null;
        this.cc = c2;
        this.lines = new ArrayList<String>(Arrays.asList(Strings.splitLines(string)));
    }

    public IniFileEditor(String string) {
        this(string, null);
    }

    public void setCommentChar(Character c2) {
        this.cc = c2;
    }

    public Character getCommantChar() {
        return this.cc;
    }

    public void update() throws IOException {
        this.write(this.file);
    }

    public void write(File file) throws IOException {
        IO.writeLines(file, this.lines, Charset.defaultCharset());
    }

    public List<String> getSectionNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.lines.size(); ++i) {
            String string = this.lines.get(i).trim();
            if (!string.startsWith("[") || !string.endsWith("]")) continue;
            arrayList.add(string.substring(1, string.length() - 1));
        }
        return arrayList;
    }

    public List<String> getSectionContents(String string) {
        int[] nArray = this.getSection(string, false);
        if (nArray == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : this.lines.subList(nArray[0], nArray[1])) {
            if ((string2 = string2.trim()).isEmpty()) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public Map<String, String> getSectionKeyValues(String string) {
        int[] nArray = this.getSection(string, false);
        if (nArray == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (String string2 : this.lines.subList(nArray[0], nArray[1])) {
            if ((string2 = string2.trim()).isEmpty() || this.cc != null && string2.charAt(0) == this.cc.charValue()) continue;
            String[] stringArray = string2.split("=", 2);
            if (stringArray.length == 2) {
                linkedHashMap.put(stringArray[0].trim(), stringArray[1].trim());
                continue;
            }
            logger.warn("Illegal key-value line in ini file: %s", string2);
        }
        return linkedHashMap;
    }

    public void setSectionContents(String string, List<String> list) {
        int[] nArray = this.getSection(string, true);
        int n2 = nArray[0];
        int n3 = nArray[1];
        if (n2 < this.lines.size()) {
            int n4 = n3 - n2;
            while (n4-- > 0) {
                this.lines.remove(n2);
            }
        }
        for (String string2 : list) {
            if ((string2 = string2.trim()).isEmpty()) continue;
            this.lines.add(n2, string2);
            ++n2;
        }
        this.lines.add(n2, "");
    }

    private int[] getSection(String string, boolean bl) {
        String string2;
        int n2;
        if (string == null) {
            String string3;
            int n3;
            for (n3 = 0; n3 < this.lines.size() && !(string3 = this.lines.get(n3).trim()).startsWith("["); ++n3) {
            }
            return new int[]{0, n3};
        }
        String string4 = "[" + string + "]";
        int n4 = -1;
        int n5 = -1;
        for (n2 = 0; n2 < this.lines.size(); ++n2) {
            string2 = this.lines.get(n2).trim();
            if (!string2.equals(string4)) continue;
            n4 = n2 + 1;
            break;
        }
        if (n4 < 0) {
            if (!bl) {
                return null;
            }
            this.lines.add(string4);
            n4 = this.lines.size();
        }
        for (n2 = n4; n2 < this.lines.size(); ++n2) {
            string2 = this.lines.get(n2).trim();
            if (!string2.startsWith("[")) continue;
            n5 = n2;
            break;
        }
        if (n5 < 0) {
            n5 = this.lines.size();
        }
        return new int[]{n4, n5};
    }

    public String getValue(String string) {
        return this.getValue(null, string, "=");
    }

    public String getValue(String string, String string2) {
        return this.getValue(string, string2, "=");
    }

    public String getValue(String string, String string2, String string3) {
        for (String string4 : this.getSectionContents(string)) {
            String string5;
            int n2 = string4.indexOf(string3);
            if (n2 < 0 || !(string5 = string4.substring(0, n2).trim()).equals(string2)) continue;
            return string4.substring(n2 + string3.length()).trim();
        }
        return null;
    }

    public boolean setValue(String string, String string2, String string3) {
        return this.setValue(string, string2, string3, "=");
    }

    public boolean setValue(String string, String string2, String string3, String string4) {
        int n2;
        List<String> list = this.getSectionContents(string);
        for (n2 = 0; n2 < list.size(); ++n2) {
            String string5;
            String string6 = list.get(n2);
            int n3 = string6.indexOf(string4);
            if (n3 < 0 || !(string5 = string6.substring(0, n3).trim()).equals(string2)) continue;
            String string7 = string6.substring(n3 + string4.length()).trim();
            if (string7.equals(string3)) {
                return false;
            }
            list.set(n2, string2 + string4 + string3);
            break;
        }
        if (n2 >= list.size()) {
            list.add(string2 + string4 + string3);
        }
        this.setSectionContents(string, list);
        return true;
    }
}

