/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.base;

import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.HashMap;
import java.util.Map;

@Ser
public class Flags {
    @SerId(value=1)
    private int flags;
    @SerId(value=2)
    private int allowed;
    @SerId(value=3)
    private Map<Integer, String> namemap;

    public Flags() {
        this(0);
    }

    public Flags(int n2) {
        this(n2, -1, null);
    }

    public Flags(int n2, int n3, Map<Integer, String> map) {
        this.flags = n2;
        this.allowed = n3;
        if (map != null) {
            for (int n4 : map.keySet()) {
                String string;
                if (!this.isValidBit(n4) || Strings.isBlank(string = map.get(n4))) continue;
                if (this.namemap == null) {
                    this.namemap = new HashMap<Integer, String>();
                }
                this.namemap.put(n4, string);
            }
        }
    }

    public void verify(int n2) {
        if ((n2 | this.allowed) != this.allowed) {
            throw new IllegalStateException(Strings.ff("Illegal flags: 0x%X", n2 & ~this.allowed));
        }
    }

    public int get() {
        return this.flags;
    }

    public boolean set(int n2) {
        this.verify(n2);
        if (n2 == this.flags) {
            return false;
        }
        this.flags = n2;
        return true;
    }

    public boolean isValidBit(int n2) {
        return (this.allowed & 1 << n2) != 0;
    }

    public boolean testBit(int n2) {
        if (n2 < 0 || n2 > 31) {
            throw new IllegalArgumentException("Bit index out of range: " + n2);
        }
        return (this.flags & 1 << n2) != 0;
    }

    public boolean has(int n2) {
        return (this.flags & n2) == n2;
    }

    public boolean hasSome(int n2) {
        return (this.flags & n2) != 0;
    }

    public boolean hasNone(int n2) {
        return (this.flags & n2) == 0;
    }

    public boolean addTo(int n2) {
        this.verify(n2);
        if (this.has(n2)) {
            return false;
        }
        this.flags |= n2;
        return true;
    }

    public boolean removeFrom(int n2) {
        if (this.hasNone(n2)) {
            return false;
        }
        this.flags &= ~n2;
        return true;
    }

    public boolean update(int n2, boolean bl) {
        return bl ? this.addTo(n2) : this.removeFrom(n2);
    }

    public String toString() {
        return Strings.ff("0x%08X", this.flags);
    }

    public static int set(int n2, int n3, boolean bl) {
        return bl ? n2 | n3 : n2 & ~n3;
    }

    public static boolean has(int n2, int n3) {
        return (n2 & n3) == n3;
    }
}

