/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.base;

import com.pnfsoftware.jeb.util.base.BashHelper;
import com.pnfsoftware.jeb.util.base.OSType;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.HashMap;
import java.util.Map;

public class Env {
    private static final ILogger logger = GlobalLog.getLogger(Env.class);
    private static OSType ostype = OSType.determine();
    private static boolean useCacheForQuickRetrieval = false;
    private static Map<String, String> envmap = new HashMap<String, String>();

    private static boolean record(String string, String string2, int n2) {
        String string3 = envmap.put(string, string2);
        if (string3 == null && string2 == null || string3 != null && string3.equals(string2)) {
            return string2 != null;
        }
        if (n2 >= 0) {
            String string4 = "Environment variable";
            if (n2 == 0) {
                string4 = "System environment variable";
            } else if (n2 == 1) {
                string4 = "Shell environment variable";
            }
            if (string2 == null) {
                logger.debug("%s not found: %s", string4, string);
            } else {
                logger.debug("%s found: %s=%s", string4, string, string2);
            }
        }
        return string2 != null;
    }

    public static String get(String string) {
        String string2 = System.getenv(string);
        if (Env.record(string, string2, 0)) {
            return string2;
        }
        if (!ostype.isWindows()) {
            if (useCacheForQuickRetrieval && envmap.containsKey(string)) {
                return envmap.get(string);
            }
            string2 = BashHelper.env(string);
            if (Env.record(string, string2, 1)) {
                return string2;
            }
        }
        return null;
    }

    public static String getsafe(String string) {
        return Strings.safe(Env.get(string));
    }
}

