/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.base;

import com.pnfsoftware.jeb.util.base.Throwables;
import com.pnfsoftware.jeb.util.format.Strings;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;

public class Enums {
    public static <T extends Enum<T>> int getValue(Enum<T> enum_) {
        try {
            int n2 = 0;
            for (Field field : enum_.getClass().getDeclaredFields()) {
                if (!field.isEnumConstant()) continue;
                if (enum_.ordinal() == n2) {
                    Value value = field.getAnnotation(Value.class);
                    if (value == null) {
                        throw new IllegalArgumentException("Enum-constant does not specify a value");
                    }
                    return value.value();
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            Throwables.rethrowUnchecked(exception);
        }
        throw new RuntimeException();
    }

    public static <T extends Enum<T>> T fromValue(Class<? extends Enum<T>> clazz, int n2) {
        try {
            int n3 = 0;
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.isEnumConstant()) continue;
                Value value = field.getAnnotation(Value.class);
                if (value != null && value.value() == n2) {
                    return (T)clazz.getEnumConstants()[n3];
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            Throwables.rethrowUnchecked(exception);
        }
        throw new IllegalArgumentException(Strings.ff("Cannot find enum-constant having value %d in enum %s", n2, clazz.getName()));
    }

    @SafeVarargs
    public static <T extends Enum<T>> boolean isAnyOf(T t, T ... TArray) {
        for (T t2 : TArray) {
            if (t2 != t) continue;
            return true;
        }
        return false;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Value {
        public int value();
    }
}

