/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.base;

import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

@Ser
public abstract class DynamicEnum<E extends DynamicEnum<E>> {
    @SerId(value=1)
    protected final int id;
    @SerId(value=2)
    protected final String name;

    protected DynamicEnum(int n2, String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Must have a non-empty name");
        }
        this.id = n2;
        this.name = string;
    }

    public int id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public abstract int ordinal();

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object object) {
        return object == this;
    }

    public String toString() {
        return this.name;
    }

    protected static final <E extends DynamicEnum<E>> int ordinal(Map<String, E> map, E e) {
        int n2 = 0;
        for (DynamicEnum dynamicEnum : map.values()) {
            if (dynamicEnum == e) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    protected static final <E extends DynamicEnum<E>> E valueOf(Map<String, E> map, int n2, E e) {
        for (DynamicEnum dynamicEnum : map.values()) {
            if (dynamicEnum.id != n2) continue;
            return (E)dynamicEnum;
        }
        return e;
    }

    protected static final <E extends DynamicEnum<E>> E valueOf(Map<String, E> map, String string, E e) {
        return (E)((DynamicEnum)map.getOrDefault(string, e));
    }

    protected static final <E extends DynamicEnum<E>> Collection<E> values(Map<String, E> map) {
        return Collections.unmodifiableCollection(map.values());
    }

    protected static final <E extends DynamicEnum<E>> void verifyAvailability(Map<String, E> map, int n2, String string) {
        for (DynamicEnum dynamicEnum : map.values()) {
            if (dynamicEnum.id != n2 && !dynamicEnum.name.equals(string)) continue;
            throw new IllegalArgumentException("Duplicate entry found!");
        }
    }

    protected static final <E extends DynamicEnum<E>> boolean isBuiltin(Map<String, E> map, int n2, E e) {
        int n3 = new ArrayList<String>(map.keySet()).indexOf(e.name);
        return n3 < n2;
    }

    protected static final synchronized <E extends DynamicEnum<E>> E register(Map<String, E> map, E e) {
        DynamicEnum.verifyAvailability(map, e.id, e.name);
        map.put(e.name(), e);
        return e;
    }

    protected static final synchronized <E extends DynamicEnum<E>> boolean unregister(Map<String, E> map, int n2, String string) {
        DynamicEnum dynamicEnum = (DynamicEnum)map.get(string);
        if (dynamicEnum == null || DynamicEnum.isBuiltin(map, n2, dynamicEnum)) {
            return false;
        }
        return map.remove(dynamicEnum.name) != null;
    }

    public boolean isCompatibleWith(E e) {
        if (e == null) {
            return false;
        }
        if (e == this) {
            return true;
        }
        if (this.name.startsWith(((DynamicEnum)e).name + "_")) {
            return true;
        }
        return ((DynamicEnum)e).name.startsWith(this.name + "_");
    }
}

