/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.base;

import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class BashHelper {
    private static final ILogger logger = GlobalLog.getLogger(BashHelper.class);
    private static final long bashWaitTimeSeconds = 5L;

    public static Map<String, String> env() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = BashHelper.exec("env");
        if (string != null) {
            for (String string2 : Strings.splitLines(string)) {
                String[] stringArray;
                if ((string2 = Strings.trim(string2)).isEmpty() || (stringArray = string2.split("=", 2)).length != 2) continue;
                hashMap.put(stringArray[0], stringArray[1]);
            }
        }
        return hashMap;
    }

    public static String env(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        String string2 = BashHelper.exec("echo $" + string);
        if (string2 == null) {
            return null;
        }
        if ((string2 = Strings.trim(string2)).isEmpty()) {
            return null;
        }
        return string2;
    }

    private static String exec(String string) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("bash", "-ic", string);
            Process process = processBuilder.start();
            process.waitFor(5L, TimeUnit.SECONDS);
            byte[] byArray = IO.readInputStream(process.getInputStream());
            return Strings.decodeLocal(byArray);
        }
        catch (Exception exception) {
            logger.catching(exception);
            return null;
        }
    }
}

