/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.base;

import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.Arrays;

public abstract class Assert {
    private static final ILogger logger = GlobalLog.getLogger(Assert.class);
    private static final String assertClassName = Assert.class.getName();

    private static RuntimeException adjustException(RuntimeException runtimeException) {
        if (runtimeException == null) {
            throw new RuntimeException();
        }
        try {
            int n2;
            StackTraceElement[] stackTraceElementArray = runtimeException.getStackTrace();
            for (n2 = 0; n2 < stackTraceElementArray.length && assertClassName.equals(stackTraceElementArray[n2].getClassName()); ++n2) {
            }
            if (n2 > 0) {
                stackTraceElementArray = Arrays.copyOfRange(stackTraceElementArray, n2, stackTraceElementArray.length);
                runtimeException.setStackTrace(stackTraceElementArray);
            }
        }
        catch (Exception exception) {}
        return runtimeException;
    }

    public static void a(boolean bl, String string) {
        if (!bl) {
            String string2 = "FAIL - unexpected condition" + (String)(string == null ? "" : ": " + string);
            RuntimeException runtimeException = new RuntimeException(string2);
            throw Assert.adjustException(runtimeException);
        }
    }

    public static void a(boolean bl, String string, Object ... objectArray) {
        if (!bl) {
            String string2 = "FAIL - unexpected condition" + (String)(string == null ? "" : ": " + Strings.f(string, objectArray));
            RuntimeException runtimeException = new RuntimeException(string2);
            throw Assert.adjustException(runtimeException);
        }
    }

    public static void a(boolean bl) {
        Assert.a(bl, null);
    }

    public static void fail(String string) {
        String string2 = "FAIL" + (String)(string == null ? "" : ": " + string);
        RuntimeException runtimeException = new RuntimeException(string2);
        throw Assert.adjustException(runtimeException);
    }

    public static void fail() {
        Assert.fail(null);
    }

    public static void debugFail(String string) {
        String string2 = "[DEBUG] FAIL" + (String)(string == null ? "" : ": " + string);
        logger.error(string2, new Object[0]);
    }

    public static void debugFail() {
        Assert.debugFail((String)null);
    }

    public static void debugFail(Throwable throwable) {
        logger.catchingSilent(throwable);
    }
}

