/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.zip;

import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeBoolean;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.corei.parsers.zip.ca;
import java.util.Map;

public class ZipIdentifier
extends AbstractUnitIdentifier {
    public static final String TYPE = "zip";
    public static final String propnameProcessEntriesLazily = "ProcessEntriesLazily";

    public ZipIdentifier() {
        super(TYPE, 0.0);
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("ZIP archive handler", "ZIP file inflater based on Apache commons-compress", "PNF Software", Version.create(0, 3, 0));
    }

    @Override
    public void initialize(IPropertyDefinitionManager iPropertyDefinitionManager) {
        super.initialize(iPropertyDefinitionManager);
        this.pdm.addDefinition(propnameProcessEntriesLazily, PropertyTypeBoolean.create(true), "The zipped entries will only be processed when required (i.e. when requested by the user). To allow recovery mode for truncated archives, this setting must be enabled.");
    }

    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator, String string, Map<Object, Object> map) {
        return ZipIdentifier.checkBytes(iInput, 0, 80, 75, 3, 4) || ZipIdentifier.checkBytes(iInput, 0, 80, 75, 5, 6);
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, Map<Object, Object> map) {
        ca ca2 = new ca(string, iInput, iUnitProcessor, iUnitCreator, this.pdm);
        return ca2;
    }
}

