/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.xml;

import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.corei.parsers.xml.LH;
import com.pnfsoftware.jeb.corei.parsers.xml.ri;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.Map;

public class XmlIdentifier
extends AbstractUnitIdentifier {
    private static final ILogger logger = GlobalLog.getLogger(XmlIdentifier.class);
    public static final String TYPE = "xml";

    public XmlIdentifier() {
        super(TYPE, 0.0);
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("XML reader", "XML reader with re-formatting/beautifying", "PNF Software", Version.create(1, 0, 0));
    }

    @Override
    public void initialize(IPropertyDefinitionManager iPropertyDefinitionManager) {
        super.initialize(iPropertyDefinitionManager);
        ri.ce(this.pdm);
    }

    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator, String string, Map<Object, Object> map) {
        if (iInput == null) {
            return false;
        }
        String[] stringArray = new String[]{".html", ".htm", ".svg"};
        if (string != null && Strings.endsWith(string.toLowerCase(), stringArray)) {
            return false;
        }
        byte[] byArray = XmlIdentifier.getNonWhitespaceHeader(iInput, 5, true, new char[0]);
        if (byArray == null || byArray.length == 0) {
            return false;
        }
        if (XmlIdentifier.isXMLHeader(byArray)) {
            return true;
        }
        return string != null && string.endsWith(".xml") && byArray[0] == 60;
    }

    static boolean isXMLHeader(byte[] byArray) {
        return XmlIdentifier.checkBytes(byArray, 0, false, 60, 63, 120, 109, 108);
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, Map<Object, Object> map) {
        LH lH = new LH(string, iInput, iUnitProcessor, iUnitCreator, this.pdm);
        return lH;
    }
}

