/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.winpe;

import com.pnfsoftware.jeb.core.units.codeobject.ICOFFHeader;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.nio.ByteBuffer;

@Ser
public class Qb
implements ICOFFHeader {
    public static final int ce = 20;
    @SerId(value=1)
    public int mm;
    @SerId(value=2)
    public int fz;
    @SerId(value=3)
    public int Rs;
    @SerId(value=4)
    public int ok;
    @SerId(value=5)
    public int mH;
    @SerId(value=6)
    public int tA;
    @SerId(value=7)
    public int hG;

    public static Qb ce(ByteBuffer byteBuffer) {
        Qb qb = new Qb();
        qb.mm = byteBuffer.getShort() & 0xFFFF;
        qb.fz = byteBuffer.getShort() & 0xFFFF;
        qb.Rs = byteBuffer.getInt();
        qb.ok = byteBuffer.getInt();
        qb.mH = byteBuffer.getInt();
        qb.tA = byteBuffer.getShort() & 0xFFFF;
        qb.hG = byteBuffer.getShort() & 0xFFFF;
        return qb;
    }

    @Override
    public int getMachine() {
        return this.mm;
    }

    @Override
    public int getNumberOfSections() {
        return this.fz;
    }

    @Override
    public int getTimeDateStamp() {
        return this.Rs;
    }

    @Override
    public long getTimestampMs() {
        return ((long)this.Rs & 0xFFFFFFFFL) * 1000L;
    }

    @Override
    public int getPointerToSymbolTable() {
        return this.ok;
    }

    @Override
    public int getNumberOfSymbols() {
        return this.mH;
    }

    @Override
    public int getSizeOfOptionalHeader() {
        return this.tA;
    }

    @Override
    public int getCharacteristics() {
        return this.hG;
    }
}

