/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.winpe;

import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.JebCoreService;
import com.pnfsoftware.jeb.core.exceptions.JebRuntimeException;
import com.pnfsoftware.jeb.core.input.BytesInput;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.input.SubInput;
import com.pnfsoftware.jeb.core.output.IUnitFormatter;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.core.units.NotificationType;
import com.pnfsoftware.jeb.core.units.UnitNotification;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.code.asm.memory.MemoryException;
import com.pnfsoftware.jeb.core.units.code.asm.memory.VirtualMemoryUtil;
import com.pnfsoftware.jeb.core.units.codeobject.AbstractCodeObjectUnit;
import com.pnfsoftware.jeb.core.units.codeobject.CoffDebugDirectoryEntry;
import com.pnfsoftware.jeb.core.units.codeobject.ICOFFHeader;
import com.pnfsoftware.jeb.core.units.codeobject.ICOFFSectionHeader;
import com.pnfsoftware.jeb.core.units.codeobject.ILinkInfoProvider;
import com.pnfsoftware.jeb.core.units.codeobject.IPECOFFUnit;
import com.pnfsoftware.jeb.core.units.codeobject.IPEOptionalHeader;
import com.pnfsoftware.jeb.core.units.codeobject.ISegmentInformation;
import com.pnfsoftware.jeb.core.units.codeobject.LoaderInformation;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.core.units.codeobject.SegmentInformation;
import com.pnfsoftware.jeb.core.units.codeobject.SubsystemType;
import com.pnfsoftware.jeb.core.units.codeobject.SymbolInformation;
import com.pnfsoftware.jeb.core.units.codeobject.SymbolType;
import com.pnfsoftware.jeb.core.units.impl.ContainerUnit;
import com.pnfsoftware.jeb.corei.parsers.winpe.HY;
import com.pnfsoftware.jeb.corei.parsers.winpe.Hl;
import com.pnfsoftware.jeb.corei.parsers.winpe.LH;
import com.pnfsoftware.jeb.corei.parsers.winpe.Qb;
import com.pnfsoftware.jeb.corei.parsers.winpe.cU;
import com.pnfsoftware.jeb.corei.parsers.winpe.ca;
import com.pnfsoftware.jeb.corei.parsers.winpe.jC;
import com.pnfsoftware.jeb.corei.parsers.winpe.ri;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.collect.Maps;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.ByteBufferUtil;
import com.pnfsoftware.jeb.util.io.ChannelUtil;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import com.pnfsoftware.jeb.util.io.Endianness;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.math.MathUtil;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jebglobal.cne;
import com.pnfsoftware.jebglobal.cnf;
import com.pnfsoftware.jebglobal.cng;
import com.pnfsoftware.jebglobal.cni;
import com.pnfsoftware.jebglobal.cnn;
import com.pnfsoftware.jebglobal.cno;
import com.pnfsoftware.jebglobal.cnp;
import com.pnfsoftware.jebglobal.cnq;
import com.pnfsoftware.jebglobal.cnr;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

@Ser
public class Kh
extends AbstractCodeObjectUnit
implements IPECOFFUnit {
    private static final ILogger ch = GlobalLog.getLogger(Kh.class);
    @SerId(value=1)
    Qb ce;
    @SerId(value=2)
    HY mm;
    @SerId(value=3)
    cU[] fz;
    @SerId(value=4)
    boolean Rs;
    @SerId(value=5)
    boolean ok;
    @SerId(value=6)
    boolean mH;
    @SerId(value=7)
    boolean tA;
    @SerId(value=8)
    ca hG;
    @SerId(value=9)
    Hl ZQ;
    @SerId(value=10)
    List<CoffDebugDirectoryEntry> lg;

    public Kh(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, IPropertyDefinitionManager iPropertyDefinitionManager) {
        super(iInput, "winpe", string, iUnitProcessor, iUnitCreator, iPropertyDefinitionManager);
    }

    @Override
    public boolean isPE64() {
        return this.Rs;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean processInternal() {
        int n2;
        Object object;
        Object object2;
        Object object3;
        long l2 = 0L;
        try {
            object3 = this.getInput().getChannel();
            try {
                int n3;
                int n4;
                long l3 = object3.size();
                if (l3 <= 64L) {
                    boolean bl = false;
                    return bl;
                }
                if (ChannelUtil.getLEShort((SeekableByteChannel)object3, 0L) != 23117) {
                    boolean bl = false;
                    return bl;
                }
                int n5 = ChannelUtil.getLEInt((SeekableByteChannel)object3, 60L);
                if (n5 < 0 || (long)(n5 + 4) > l3) {
                    boolean bl = false;
                    return bl;
                }
                if (ChannelUtil.getLEInt((SeekableByteChannel)object3, n5) != 17744) {
                    boolean bl = false;
                    return bl;
                }
                object2 = ByteBuffer.allocate(20).order(ByteOrder.LITTLE_ENDIAN);
                object3.position(n5 + 4);
                if (object3.read((ByteBuffer)object2) != 20) {
                    boolean bl = false;
                    return bl;
                }
                ((ByteBuffer)object2).rewind();
                this.ce = Qb.ce((ByteBuffer)object2);
                short s2 = ChannelUtil.getLEShort((SeekableByteChannel)object3, n5 + 4 + 20);
                if (s2 == 523) {
                    this.Rs = true;
                } else if (s2 != 267) {
                    ch.error("Invalid optional header magic: %X", s2);
                    boolean bl = false;
                    return bl;
                }
                object2 = ByteBuffer.allocate(512).order(ByteOrder.LITTLE_ENDIAN);
                object3.position(n5 + 4 + 20);
                int n6 = object3.read((ByteBuffer)object2);
                if (n6 < 69) {
                    boolean bl = false;
                    return bl;
                }
                ((ByteBuffer)object2).rewind();
                ((ByteBuffer)object2).limit(n6);
                this.mm = HY.ce((ByteBuffer)object2, this.Rs);
                int n7 = this.mm.UE;
                int n8 = this.mm.ch;
                if (!MathUtil.isPowerOfTwo(n7) || !MathUtil.isPowerOfTwo(n8)) {
                    ch.error("Invalid alignments, must be a power of 2 (file=%Xh, section=%Xh)", n7, n8);
                    boolean bl = false;
                    return bl;
                }
                if (n8 <= 4096) {
                    this.ok = true;
                }
                if (n7 > n8) {
                    ch.error("Invalid alignments (file=%Xh, section=%Xh)", n7, n8);
                    boolean bl = false;
                    return bl;
                }
                this.fz = new cU[this.ce.fz];
                if (this.fz.length > 0) {
                    object3.position(n5 + 4 + 20 + this.ce.tA);
                    object2 = ByteBuffer.allocate(40).order(ByteOrder.LITTLE_ENDIAN);
                    long l4 = -1L;
                    for (n4 = 0; n4 < this.fz.length; ++n4) {
                        String string;
                        int n9;
                        long l5;
                        long l6;
                        long l7;
                        ((ByteBuffer)object2).rewind();
                        if (object3.read((ByteBuffer)object2) != 40) {
                            boolean bl = false;
                            return bl;
                        }
                        ((ByteBuffer)object2).rewind();
                        object = cU.ce((ByteBuffer)object2);
                        this.fz[n4] = object;
                        long l8 = ((cU)object).mH;
                        long l9 = ((cU)object).ok;
                        long l10 = ((cU)object).fz;
                        if (!this.ok) {
                            l7 = l8 & 0xFFFFFFFFFFFFFE00L;
                            l6 = (l8 + l9 + (long)n7 - 1L & (long)(~(n7 - 1))) - l7;
                            l6 = Math.min(l6, l9 + 4095L & 0xFFFFFFFFFFFFF000L);
                            if (l10 != 0L) {
                                l6 = Math.min(l6, l10 + 4095L & 0xFFFFFFFFFFFFF000L);
                            }
                        } else {
                            l7 = l8 & (long)(~(n7 - 1));
                            l6 = l9;
                            if (l10 != 0L) {
                                l6 = Math.min(l6, l10 + (long)n8 - 1L & (long)(~(n8 - 1)));
                            }
                        }
                        if (l6 > Integer.MAX_VALUE) {
                            throw new RuntimeException("Section is too large");
                        }
                        long l11 = l7 + l6;
                        if (l11 > l2) {
                            l2 = l11;
                        }
                        if ((l5 = ((cU)object).Rs) % (long)n8 != 0L) {
                            ch.error("Invalid segment memory address", new Object[0]);
                            boolean bl = false;
                            return bl;
                        }
                        if (l10 == 0L) {
                            l10 = l6;
                        }
                        if (l4 != -1L && l4 != l5) {
                            String string2 = Strings.ff("Illegal section, PE unlikely to load: expected RVA= %Xh, actual=%Xh", l4, l5);
                            this.addNotification(new UnitNotification(NotificationType.CORRUPTION, string2));
                        }
                        long l12 = (l10 + (long)n8 - 1L) / (long)n8 * (long)n8;
                        l4 = l5 + l12;
                        try {
                            for (n9 = 0; n9 < ((cU)object).mm.length && ((cU)object).mm[n9] != 0; ++n9) {
                            }
                            string = Strings.decodeASCII(((cU)object).mm, 0, n9);
                        }
                        catch (Exception exception) {
                            string = "";
                        }
                        n9 = this.mm(((cU)object).ch);
                        this.addSegment(new SegmentInformation(string, l7, l6, l5, l12, n9));
                        Object[] objectArray = new Object[]{string, l7, l6, l5, l12};
                    }
                }
                int n10 = (int)object3.size();
                if (this.fz.length >= 1) {
                    n3 = (int)this.fz[0].mH;
                    for (n4 = 1; n3 == 0 && n4 < this.fz.length; ++n4) {
                        n3 = (int)this.fz[n4].mH;
                    }
                    if (n3 != 0 && n3 < n10) {
                        n10 = n3;
                    }
                }
                if ((n3 = (int)this.mm.GR) < n10) {
                    n10 = n3;
                }
                this.insertSegment(0, new SegmentInformation("<hdr>", 0L, n10, 0L, n10, 2));
                if (this.ce.ok != 0 && this.ce.mH >= 0) {
                    this.ce((SeekableByteChannel)object3);
                }
            }
            finally {
                if (object3 != null) {
                    object3.close();
                }
            }
        }
        catch (IOException iOException) {
            (new Object[1])[0] = iOException;
            return false;
        }
        object3 = new LoaderInformation.Builder();
        int n11 = 0;
        if ((this.ce.hG & 0x2000) != 0) {
            n11 |= 4;
            n11 |= 0x20;
        }
        ((LoaderInformation.Builder)object3).setFlags(n11);
        ((LoaderInformation.Builder)object3).setTargetProcessor(this.fz(this.ce.mm));
        ((LoaderInformation.Builder)object3).setTargetSubsystem(this.ok(this.mm.GH));
        ((LoaderInformation.Builder)object3).setEndianness(this.Rs(this.ce.mm));
        ((LoaderInformation.Builder)object3).setWordSize(this.Rs ? 64 : 32);
        ((LoaderInformation.Builder)object3).setCompilationTimestamp(this.ce.getTimestampMs());
        ((LoaderInformation.Builder)object3).setImageBase(this.mm.lg);
        ((LoaderInformation.Builder)object3).setImageSize(this.mm.dT);
        ((LoaderInformation.Builder)object3).setEntryPoint(this.mm.tA);
        ((LoaderInformation.Builder)object3).setOverlayOffset(l2);
        this.setLoaderInformation(((LoaderInformation.Builder)object3).build());
        for (n2 = 0; n2 < this.mm.bB.length; ++n2) {
            ri ri2 = this.mm.bB[n2];
            object2 = n2 < ri.ce.length ? ri.ce[n2] : "-";
            long l13 = 0L;
            if (ri2.fz != 0L) {
                l13 = this.convertRelativeAddressToFileOffset(ri2.fz);
            }
            this.addSection(new SegmentInformation((String)object2, l13, ri2.Rs, ri2.fz, ri2.Rs, 0));
        }
        if ((this.ce.hG & 2) != 0) {
            Assert.a(this.getRawMemoryMappedImage() != null);
            try {
                this.ok();
            }
            catch (MemoryException memoryException) {
                this.logError(true, "Unable to process Exports", new Object[0]);
                JebCoreService.notifySilentExceptionToClient(new JebRuntimeException("exports processing failed"));
            }
            try {
                this.Rs();
            }
            catch (MemoryException memoryException) {
                this.logError(true, "Unable to process Imports", new Object[0]);
                JebCoreService.notifySilentExceptionToClient(new JebRuntimeException("imports processing failed"));
            }
            try {
                this.hG();
            }
            catch (MemoryException memoryException) {
                this.logError(true, "Unable to process debug info", new Object[0]);
                JebCoreService.notifySilentExceptionToClient(new JebRuntimeException("debug info processing failed"));
            }
            try {
                this.mH();
            }
            catch (MemoryException memoryException) {
                this.logError(true, "Unable to process Thread Local Storage", new Object[0]);
                JebCoreService.notifySilentExceptionToClient(new JebRuntimeException("TLS processing failed"));
            }
            try {
                this.tA();
            }
            catch (MemoryException memoryException) {
                this.logError(true, "Unable to parse Rich header", new Object[0]);
                JebCoreService.notifySilentExceptionToClient(new JebRuntimeException("rich header processing failed"));
            }
            n2 = 1;
            if (n2 != 0) {
                try {
                    object2 = Kh.ce(this.ce);
                    IUnit iUnit = object2 != null ? this.getUnitProcessor().process((String)object2 + " image", this.getInput(), this, (String)object2, true, true) : this.getUnitProcessor().process(null, this.getInput(), this, "code_disa", true, true);
                    if (iUnit != null) {
                        this.addChild(iUnit);
                    } else {
                        this.logError(true, "No matching disassembler found.", new Object[0]);
                    }
                }
                catch (Exception exception) {
                    ch.catching(exception);
                    this.addNotification(new UnitNotification(NotificationType.UNSUPPORTED_FEATURE, "The machine code was not disassembled"));
                }
            }
        }
        if (this.mm.bB.length > 2) {
            ri ri3 = this.mm.bB[2];
            if (ri3.fz > 0L && ri3.Rs > 0L) {
                cnp cnp2 = new cnp(this.getRawMemoryMappedImage(), this.mm.lg + ri3.fz, ri3.Rs);
                try {
                    cnp2.mH();
                    int n12 = cnp2.ok();
                    if (n12 > 3) {
                        this.logWarn(true, "PE uses a non-standard type/name/language resource tree; max tree depth is %d when It should be 3", n12);
                    }
                    if (cnp2.mm() && !cnp2.fz()) {
                        this.logWarn(true, "PE has a resource tree but does not contain resource data", new Object[0]);
                    }
                    if (cnp2.fz()) {
                        ContainerUnit containerUnit = new ContainerUnit("Resources", this.getUnitProcessor(), this, this.getPropertyDefinitionManager());
                        containerUnit.process();
                        this.addChild(containerUnit);
                        StringBuilder stringBuilder = new StringBuilder();
                        cnq cnq2 = new cnq();
                        cno cno2 = cnp2.ce();
                        for (cno cno3 : cno2.mH()) {
                            if (cno3.tA()) continue;
                            String string = cnp2.ce(cno3);
                            object = cnp2.mm(cno3);
                            ContainerUnit containerUnit2 = new ContainerUnit((String)object, containerUnit.getUnitProcessor(), containerUnit, containerUnit.getPropertyDefinitionManager());
                            containerUnit2.process();
                            containerUnit.addChild(containerUnit2);
                            for (cnn cnn2 : cno3.ZQ()) {
                                String string3 = cnp2.mm(cnn2.ce());
                                byte[] byArray = new byte[cnn2.fz()];
                                this.getRawMemoryMappedImage().read(this.mm.lg + (long)cnn2.mm(), cnn2.fz(), byArray, 0);
                                IUnit iUnit = this.getUnitProcessor().process(string3, new BytesInput(byArray), containerUnit2);
                                if (iUnit != null) {
                                    containerUnit2.addChildUnit(iUnit);
                                } else {
                                    this.logError(true, "Cannot parse Resource entry \"%s\"", string3);
                                }
                                if (cnp2.ce(cno3).equals("VERSION")) {
                                    try {
                                        cnr cnr2 = new cnr(byArray);
                                        String string4 = cnr2.ce();
                                        if (stringBuilder.length() > 0) {
                                            stringBuilder.append(Strings.generate('-', 80) + "\n");
                                        }
                                        stringBuilder.append(string4);
                                    }
                                    catch (Exception exception) {
                                        ch.catching(exception);
                                    }
                                    continue;
                                }
                                if (string.equals("ICON") || string.equals("GROUP_ICON") || !string.equals("STRING")) continue;
                                try {
                                    cnq2.ce(cnn2, byArray);
                                }
                                catch (Exception exception) {
                                    ch.catching(exception);
                                }
                            }
                        }
                        if (stringBuilder.length() > 0) {
                            IUnit iUnit = this.getUnitProcessor().process("versions.txt", new BytesInput(Strings.encodeUTF8(stringBuilder.toString())), containerUnit);
                            containerUnit.addChild(iUnit);
                        }
                        cnq2.ce(containerUnit);
                    }
                }
                catch (Exception exception) {
                    ch.catching(exception);
                    this.logError(true, "Resources processing failed! (%s)", exception.toString());
                    JebCoreService.notifySilentExceptionToClient(exception);
                }
            }
        }
        if (this.mm.bB.length > 4) {
            ri ri4 = this.mm.bB[4];
            long l14 = ri4.fz;
            long l15 = this.getInput().getCurrentSize();
            if (l14 > 0L && l14 < l15 && ri4.Rs > 0L && ri4.Rs < l15 && l14 + ri4.Rs <= l15) {
                cnf cnf2 = new cnf(this.getInput(), (int)ri4.fz, (int)ri4.Rs);
                try {
                    try {
                        cnf2.fz();
                    }
                    catch (Exception exception) {
                        ch.catching(exception);
                    }
                    if (cnf2.ce()) {
                        ContainerUnit containerUnit = new ContainerUnit("Certificates", this.getUnitProcessor(), this, this.getPropertyDefinitionManager());
                        containerUnit.process();
                        this.addChild(containerUnit);
                        int n13 = 0;
                        for (cne cne2 : cnf2.mm()) {
                            object = cne2.Rs();
                            String string = cne2.ok();
                            String string5 = Strings.ff("Certificate #%d (%s, %s)", n13, object, string);
                            IUnit iUnit = this.getUnitProcessor().process(string5, new BytesInput(cne2.fz()), containerUnit);
                            if (iUnit != null) {
                                containerUnit.addChildUnit(iUnit);
                                continue;
                            }
                            this.logError(true, "Cannot parse Certificate entry \"%s\"", string5);
                        }
                    }
                }
                catch (Exception exception) {
                    ch.catching(exception);
                    this.logError(true, "Certificates processing failed! (%s)", exception.toString());
                    JebCoreService.notifySilentExceptionToClient(exception);
                }
            }
        }
        if (this.fz != null && this.fz.length > 0) {
            try (SeekableByteChannel seekableByteChannel = this.getInput().getChannel();){
                long l16 = seekableByteChannel.size();
                if (l16 > l2) {
                    this.tA = true;
                    long l17 = l16 - l2;
                    SubInput subInput = new SubInput(this.getInput(), l2, l17);
                    IUnit iUnit = this.getUnitProcessor().process("Appended Data", subInput, this);
                    this.addChild(iUnit);
                }
            }
            catch (IOException iOException) {
                ch.catching(iOException);
            }
        }
        return true;
    }

    private boolean ce(SeekableByteChannel seekableByteChannel) {
        if (this.ce.ok == 0 || this.ce.mH == 0) {
            return false;
        }
        com.pnfsoftware.jeb.corei.parsers.wincoff.ca[] caArray = new com.pnfsoftware.jeb.corei.parsers.wincoff.ca[this.ce.mH];
        int n2 = 0;
        try {
            seekableByteChannel.position(this.ce.ok);
            ByteBuffer byteBuffer = ByteBuffer.allocate(18).order(ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < caArray.length; ++i) {
                byteBuffer.rewind();
                if (seekableByteChannel.read(byteBuffer) != 18) {
                    return false;
                }
                byteBuffer.rewind();
                if (n2 == 0) {
                    com.pnfsoftware.jeb.corei.parsers.wincoff.ca ca2;
                    caArray[i] = ca2 = com.pnfsoftware.jeb.corei.parsers.wincoff.ca.ce(byteBuffer);
                    n2 = ca2.zO;
                    String string = this.ce(caArray[i].UE);
                    if (ca2.LS != 776 || ca2.oW != 3 && ca2.oW != 2 || ca2.Wz <= 0) continue;
                    ISegmentInformation iSegmentInformation = this.getSegment(ca2.Wz);
                    SymbolInformation symbolInformation = new SymbolInformation(SymbolType.UNKNOWN, 0, 0L, string, 0L, iSegmentInformation.getOffsetInMemory() + (long)ca2.lj, 1L);
                    this.addSymbol(symbolInformation);
                    continue;
                }
                --n2;
                Object[] cfr_ignored_0 = new Object[0];
            }
        }
        catch (Exception exception) {
            this.logError(true, "Golang COFF symbol parsing failed (%s)", exception.toString());
            JebCoreService.notifySilentExceptionToClient((Throwable)exception, Maps.toMap("reason", "Golang COFF symbol parsing failed"));
            return false;
        }
        return true;
    }

    private String ce(byte[] byArray) {
        String string;
        if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0) {
            int n2 = EndianUtil.littleEndianBytesToInt(byArray, 4);
            string = this.ce(n2);
        } else {
            try {
                int n3;
                for (n3 = 0; n3 < byArray.length && byArray[n3] != 0; ++n3) {
                }
                string = Strings.decodeASCII(byArray, 0, n3);
            }
            catch (Exception exception) {
                string = "";
            }
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String ce(int n2) {
        String string = null;
        try (SeekableByteChannel seekableByteChannel = this.getInput().getChannel();){
            seekableByteChannel.position(this.ce.ok + this.ce.mH * 18 + n2);
            int n3 = 1;
            ByteBuffer byteBuffer = ByteBuffer.allocate(n3);
            if (seekableByteChannel.read(byteBuffer) == -1) {
                String string2 = null;
                return string2;
            }
            byte[] byArray = byteBuffer.array();
            while (byArray[byArray.length - 1] != 0) {
                byteBuffer = ByteBuffer.allocate(++n3);
                seekableByteChannel.position(this.ce.ok + this.ce.mH * 18 + n2);
                if (seekableByteChannel.read(byteBuffer) == -1) {
                    String string3 = null;
                    return string3;
                }
                byArray = byteBuffer.array();
            }
            if (byArray.length == 1) {
                String string4 = "";
                return string4;
            }
            string = Strings.decodeASCII(byArray, 0, n3 - 1);
            return string;
        }
        catch (IOException iOException) {
            (new Object[1])[0] = iOException;
        }
        return string;
    }

    private static String ce(Qb qb) {
        switch (qb.mm) {
            case 332: {
                return "x86";
            }
            case 34404: {
                return "x86_64";
            }
            case 448: 
            case 450: 
            case 452: {
                return "arm";
            }
            case 43620: {
                return "arm64";
            }
            case 352: 
            case 354: 
            case 358: 
            case 360: 
            case 361: 
            case 870: {
                return "mips";
            }
        }
        return null;
    }

    private void Rs() throws MemoryException {
        if (this.mm.bB.length <= 1) {
            return;
        }
        if (this.mm.bB[1].fz == 0L) {
            return;
        }
        IVirtualMemory iVirtualMemory = this.getRawMemoryMappedImage();
        ArrayList<SymbolInformation> arrayList = new ArrayList<SymbolInformation>();
        long l2 = this.mm.lg;
        long l3 = this.ce(l2, this.mm.bB[1].fz);
        if (!this.mm(l3)) {
            return;
        }
        this.ZQ = Hl.ce(l3, iVirtualMemory, l2);
        if (this.ZQ == null) {
            return;
        }
        HashMap<CallSite, SymbolInformation> hashMap = new HashMap<CallSite, SymbolInformation>();
        for (LH lH : this.ZQ.ce) {
            lH.lg = lH.mm != 0L && iVirtualMemory.check(l2 + lH.mm, 1, 1) != 0;
            String string = this.ce(iVirtualMemory, l2 + lH.ok);
            cng cng2 = cni.ce(string);
            (new Object[1])[0] = Strings.truncate(string, 100);
            int n2 = this.Rs ? 8 : 4;
            long l4 = this.Rs ? Long.MIN_VALUE : 0x80000000L;
            long l5 = lH.mm;
            long l6 = lH.mH;
            int n3 = 0;
            long l7 = 0L;
            while (true) {
                int n4;
                long l8;
                if (lH.lg) {
                    l8 = this.Rs ? iVirtualMemory.readLELong(l2 + l5) : (long)iVirtualMemory.readLEInt(l2 + l5) & 0xFFFFFFFFL;
                } else {
                    long l9 = l8 = this.Rs ? iVirtualMemory.readLELong(l2 + l6) : (long)iVirtualMemory.readLEInt(l2 + l6) & 0xFFFFFFFFL;
                }
                if (l8 == 0L) break;
                Object object = null;
                if ((l8 & l4) != 0L) {
                    n4 = (int)l8 & 0xFFFF;
                    if (cng2 != null) {
                        object = cng2.ce(n4);
                    }
                    if (object == null) {
                        object = "#" + n4;
                    }
                } else {
                    n4 = iVirtualMemory.readLEShort(l2 + l8) & 0xFFFF;
                    object = this.ce(iVirtualMemory, l2 + l8 + 2L);
                    if (object != null) {
                        l7 = l2 + l8 + 2L + (long)((String)object).length();
                    }
                }
                Object[] objectArray = new Object[]{n4, Strings.truncate((String)object, 100)};
                String string2 = string + "!" + (String)object;
                SymbolInformation symbolInformation = new SymbolInformation(SymbolType.PTRFUNCTION, 1, n4, string2, 0L, l6, n2);
                arrayList.add(symbolInformation);
                hashMap.put((CallSite)((Object)string2), symbolInformation);
                l5 += (long)n2;
                l6 += (long)n2;
                ++n3;
            }
            lH.ZQ = n3;
            lH.ch = l7;
        }
        this.mH = this.mm.bB[1].Rs >= 40L && hashMap.containsKey("mscoree.dll!_CorExeMain");
        this.addAllSymbols(arrayList);
    }

    private void ok() throws MemoryException {
        if (this.mm.bB.length <= 0) {
            return;
        }
        if (this.mm.bB[0].fz == 0L) {
            return;
        }
        IVirtualMemory iVirtualMemory = this.getRawMemoryMappedImage();
        ArrayList<SymbolInformation> arrayList = new ArrayList<SymbolInformation>();
        long l2 = this.mm.lg;
        long l3 = this.ce(l2, this.mm.bB[0].fz);
        if (!this.mm(l3)) {
            return;
        }
        long l4 = this.mm.bB[0].fz;
        long l5 = l4 + this.mm.bB[0].Rs;
        this.hG = ca.ce(l3, iVirtualMemory, l2);
        if (this.hG == null) {
            return;
        }
        (new Object[1])[0] = Strings.truncate(Strings.safe(this.hG.UE, "-"), 100);
        long l6 = this.hG.ZQ;
        for (int i = this.hG.tA; i > 0; --i) {
            long l7 = (long)iVirtualMemory.readLEInt(l2 + l6) & 0xFFFFFFFFL;
            SymbolType symbolType = SymbolType.FUNCTION_MAYBE;
            if (l7 >= l4 && l7 < l5) {
                this.ce(iVirtualMemory, l2 + l7);
                symbolType = SymbolType.FORWARDED_FUNCTION;
            }
            SymbolInformation symbolInformation = new SymbolInformation(symbolType, 2, 0L, null, 0L, l7, 0L);
            arrayList.add(symbolInformation);
            l6 += 4L;
        }
        String string = "";
        boolean bl = true;
        long l8 = this.hG.ch;
        long l9 = this.hG.lg;
        for (int i = this.hG.hG; i > 0; --i) {
            int n2 = iVirtualMemory.readLEShort(l2 + l8) & 0xFFFF;
            l8 += 2L;
            int n3 = this.hG.mH + n2;
            long l10 = (long)iVirtualMemory.readLEInt(l2 + l9) & 0xFFFFFFFFL;
            l9 += 4L;
            String string2 = this.ce(iVirtualMemory, l2 + l10);
            if (bl && string2.compareTo(string) < 0) {
                bl = false;
            }
            if (n2 < arrayList.size()) {
                SymbolInformation symbolInformation = (SymbolInformation)arrayList.get(n2);
                symbolInformation.setName(string2);
                symbolInformation.setIdentifier(n3);
            }
            string = string2;
        }
        if (!bl) {
            this.addNotification(new UnitNotification(NotificationType.ERROR, "PE export names are out of order"));
        }
        this.addAllSymbols(arrayList);
    }

    private void mH() throws MemoryException {
        long l2;
        if (this.mm.bB.length < 10) {
            return;
        }
        ri ri2 = this.mm.bB[9];
        if (ri2.fz == 0L) {
            return;
        }
        IVirtualMemory iVirtualMemory = this.getRawMemoryMappedImage();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        long l3 = this.mm.lg;
        long l4 = this.ce(l3, ri2.fz);
        if (!this.mm(l4)) {
            return;
        }
        if (this.Rs) {
            if ((l4 = iVirtualMemory.readLELong(l4 + 24L)) != 0L) {
                while ((l2 = iVirtualMemory.readLELong(l4)) != 0L) {
                    arrayList.add((int)(l2 - l3));
                    l4 += 8L;
                }
            }
        } else if ((l4 = (long)iVirtualMemory.readLEInt(l4 + 12L) & 0xFFFFFFFFL) != 0L) {
            while ((l2 = (long)iVirtualMemory.readLEInt(l4) & 0xFFFFFFFFL) != 0L) {
                arrayList.add((int)(l2 - l3));
                l4 += 4L;
            }
        }
        ArrayList<SymbolInformation> arrayList2 = new ArrayList<SymbolInformation>();
        int n2 = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n3 = (Integer)iterator.next();
            String string = "__tls_callback_" + n2;
            SymbolInformation symbolInformation = new SymbolInformation(SymbolType.FUNCTION, 2, 0L, string, 0L, n3, 0L);
            arrayList2.add(symbolInformation);
            ++n2;
        }
        this.addAllSymbols(arrayList2);
    }

    private void tA() throws MemoryException {
        jC jC2 = new jC(this.getRawMemoryMappedImage(), this.mm.lg);
        if (jC2.ce()) {
            IUnit iUnit = this.getUnitProcessor().process("Rich header", new BytesInput(Strings.encodeUTF8(jC2.toString())), this);
            this.addChild(iUnit);
        }
    }

    private void hG() throws MemoryException {
        byte[] byArray;
        int n2;
        if (this.mm == null || this.mm.bB.length <= 6) {
            return;
        }
        ri ri2 = this.mm.bB[6];
        long l2 = this.mm.getImageBase();
        long l3 = l2 + ri2.getPosition();
        long l4 = ri2.getSize();
        IVirtualMemory iVirtualMemory = this.getRawMemoryMappedImage();
        this.lg = new ArrayList<CoffDebugDirectoryEntry>();
        long l5 = l4;
        int n3 = 28;
        while (l5 >= (long)n3 && (n2 = iVirtualMemory.read(l3, n3, byArray = new byte[n3], 0)) == n3) {
            CoffDebugDirectoryEntry coffDebugDirectoryEntry = CoffDebugDirectoryEntry.parse(l3, ByteBufferUtil.wrapLE(byArray));
            this.lg.add(coffDebugDirectoryEntry);
            l5 -= (long)n3;
            l3 += (long)n3;
        }
    }

    private String ce(IVirtualMemory iVirtualMemory, long l2) {
        int n2;
        int n3 = 256;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        int n5 = 0;
        block2: while ((n2 = VirtualMemoryUtil.readBytesSafe(iVirtualMemory, l2 + (long)n5, byArray.length - n5, byArray, n5, 1)) != -1) {
            n4 += n2;
            while (n5 < n4) {
                if (byArray[n5] == 0) break block2;
                ++n5;
            }
            if (n4 != byArray.length) break;
            byArray = Arrays.copyOf(byArray, n3 *= 2);
        }
        try {
            return new String(byArray, 0, n5, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ch.catching(unsupportedEncodingException);
            return "";
        }
    }

    private int mm(int n2) {
        int n3 = 0;
        n3 |= (n2 & 0x40000000) != 0 ? 2 : 0;
        n3 |= (n2 & Integer.MIN_VALUE) != 0 ? 1 : 0;
        return n3 |= (n2 & 0x20000000) != 0 ? 4 : 0;
    }

    private ProcessorType fz(int n2) {
        switch (n2) {
            case 332: {
                return ProcessorType.X86;
            }
            case 34404: {
                return ProcessorType.X86_64;
            }
            case 448: 
            case 450: 
            case 452: {
                return ProcessorType.ARM;
            }
            case 43620: {
                return ProcessorType.ARM64;
            }
            case 354: 
            case 358: 
            case 360: 
            case 361: 
            case 870: {
                return ProcessorType.MIPS;
            }
            case 352: {
                return ProcessorType.MIPS;
            }
        }
        return null;
    }

    private Endianness Rs(int n2) {
        switch (n2) {
            case 352: {
                return Endianness.BIG_ENDIAN;
            }
        }
        return Endianness.LITTLE_ENDIAN;
    }

    private SubsystemType ok(int n2) {
        switch (n2) {
            case 8: {
                return SubsystemType.WINDOWS_KERNEL;
            }
            case 2: 
            case 3: {
                return SubsystemType.WINDOWS_USER;
            }
        }
        return null;
    }

    public long ce(long l2, long l3) {
        return this.ce(l2 + l3);
    }

    public long ce(long l2) {
        return this.Rs ? l2 : l2 & 0xFFFFFFFFL;
    }

    public boolean mm(long l2) {
        return l2 >= this.mm.lg && l2 < this.ce(this.mm.lg, this.mm.dT);
    }

    @Override
    public long convertFileOffsetToRelativeAddress(long l2) {
        for (cU cU2 : this.fz) {
            if (l2 < cU2.mH || l2 > cU2.mH + cU2.ok) continue;
            return cU2.Rs + (l2 - cU2.mH);
        }
        return -1L;
    }

    @Override
    public long convertRelativeAddressToFileOffset(long l2) {
        for (cU cU2 : this.fz) {
            if (l2 < cU2.Rs || l2 >= cU2.Rs + cU2.fz) continue;
            return cU2.mH + (l2 - cU2.Rs);
        }
        return -1L;
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder(super.getDescription());
        if (this.isProcessed()) {
            stringBuilder.append("\nNotes:\n");
            if (this.Rs) {
                stringBuilder.append("- This is a 64-bit PE file\n");
            }
            if (this.tA) {
                stringBuilder.append("- This PE file contains appended data (unmapped)\n");
            }
            if (this.mH) {
                stringBuilder.append("- This PE file is a .NET executable\n");
            }
            if (this.ok) {
                stringBuilder.append("- This PE file has low-alignment values\n");
            }
            if (this.mm.lj >= 10) {
                Strings.ff(stringBuilder, "- The raw timeDateStamp value is 0x%08X (Win10+: may be a reproducible build id)\n", this.ce.Rs);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public IUnitFormatter getFormatter() {
        IUnitFormatter iUnitFormatter = super.getFormatter();
        return iUnitFormatter;
    }

    @Override
    public ICOFFHeader getCOFFHeader() {
        return this.ce;
    }

    @Override
    public IPEOptionalHeader getPEOptionalHeader() {
        return this.mm;
    }

    @Override
    public ICOFFSectionHeader[] getSectionHeaders() {
        return this.fz;
    }

    @Override
    protected boolean shouldAllocateFullImage() {
        return true;
    }

    @Override
    protected boolean applyRelocations(IVirtualMemory iVirtualMemory, long l2, ILinkInfoProvider iLinkInfoProvider) {
        if (this.mm.bB.length < 5) {
            return true;
        }
        ri ri2 = this.mm.bB[5];
        if (ri2.fz == 0L || ri2.Rs == 0L) {
            return true;
        }
        long l3 = this.mm.lg;
        long l4 = l2 - l3;
        if (l4 == 0L) {
            return true;
        }
        int n2 = (int)l4;
        long l5 = l4;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        try {
            int n3;
            long l6 = l2 + ri2.fz;
            for (long i = ri2.Rs; i >= 8L; i -= (long)n3) {
                int n4 = iVirtualMemory.readInt(l6);
                n3 = iVirtualMemory.readInt(l6 + 4L);
                if (i < (long)n3 || n3 < 8) {
                    throw new JebRuntimeException(Strings.ff("Bad BaseRelocation block at RVA 0x%X", l6 - l2));
                }
                long l7 = l2 + ((long)n4 & 0xFFFFFFFFL);
                byte[] byArray = new byte[(n3 - 8) / 2 * 2];
                iVirtualMemory.read(l6 + 8L, byArray.length, byArray, 0);
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                int n5 = byArray.length / 2;
                block10: while (n5-- > 0) {
                    int n6 = byteBuffer.getShort() & 0xFFFF;
                    int n7 = n6 >>> 12;
                    int n8 = n6 & 0xFFF;
                    long l8 = l7 + (long)n8;
                    switch (n7) {
                        case 0: {
                            continue block10;
                        }
                        case 1: {
                            Kh.mm(iVirtualMemory, l8, n2);
                            continue block10;
                        }
                        case 2: {
                            Kh.ce(iVirtualMemory, l8, n2);
                            continue block10;
                        }
                        case 3: {
                            Kh.fz(iVirtualMemory, l8, n2);
                            continue block10;
                        }
                        case 10: {
                            Kh.ce(iVirtualMemory, l8, l5);
                            continue block10;
                        }
                    }
                    hashSet.add(n7);
                }
                l6 += (long)n3;
            }
            if (!hashSet.isEmpty()) {
                throw new JebRuntimeException("Unsupported relocation types: " + hashSet);
            }
            return true;
        }
        catch (Exception exception) {
            JebRuntimeException jebRuntimeException = new JebRuntimeException("Cannot apply relocations", exception);
            JebCoreService.notifySilentExceptionToClient(jebRuntimeException);
            return false;
        }
    }

    private static void ce(IVirtualMemory iVirtualMemory, long l2, int n2) throws MemoryException {
        iVirtualMemory.writeShort(l2, (short)(iVirtualMemory.readShort(l2) + (n2 & 0xFFFF)));
    }

    private static void mm(IVirtualMemory iVirtualMemory, long l2, int n2) throws MemoryException {
        iVirtualMemory.writeShort(l2, (short)(iVirtualMemory.readShort(l2) + (n2 >>> 16)));
    }

    private static void fz(IVirtualMemory iVirtualMemory, long l2, int n2) throws MemoryException {
        iVirtualMemory.writeInt(l2, iVirtualMemory.readInt(l2) + n2);
    }

    private static void ce(IVirtualMemory iVirtualMemory, long l2, long l3) throws MemoryException {
        iVirtualMemory.writeLong(l2, iVirtualMemory.readLong(l2) + l3);
    }

    public ca ce() {
        return this.hG;
    }

    public Hl mm() {
        return this.ZQ;
    }

    public List<CoffDebugDirectoryEntry> fz() {
        return this.lg;
    }
}

