/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.wasm;

import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.corei.parsers.wasm.BI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;

public class WasmIdentifier
extends AbstractUnitIdentifier {
    public static final String TYPE = "wasm";

    public WasmIdentifier() {
        super(TYPE, 0.0);
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("WebAssembly module", "WebAssembly Module (wasm v1, specs 1.1) binary parser", "PNF Software", Version.create(1, 2));
    }

    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator, String string, Map<Object, Object> map) {
        if (WasmIdentifier.checkBytes(iInput, 0, 0, 97, 115, 109)) {
            ByteBuffer byteBuffer = iInput.getHeader();
            if (byteBuffer.limit() >= 64) {
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                int n2 = byteBuffer.getInt(4);
                if (n2 == 1) {
                    return true;
                }
                if (map != null) {
                    map.put("FAILURE_REASON", "The input looks like a WebAssembly binary file, but it reports an unsupported version code: " + n2);
                }
            }
        } else if (WasmIdentifier.checkBytes(iInput, 0, 40, 109, 111, 100) && map != null) {
            map.put("FAILURE_REASON", "The input looks like a WebAssembly S-expression text file (*.wat, *.wast). This plugin processes WebAssembly binaries (*.wasm) only\n.Refer to https://developer.mozilla.org/en-US/docs/WebAssembly/Text_format_to_wasm to learn how to convert WAST text to a WASM module.");
        }
        return false;
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, Map<Object, Object> map) {
        BI bI = new BI(string, iInput, iUnitProcessor, iUnitCreator, this.pdm);
        return bI;
    }
}

