/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.utf8;

import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.output.CoordinatesConversionPrecision;
import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.output.text.IAnchor;
import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.core.output.text.ILine;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.impl.AbstractTextDocument;
import com.pnfsoftware.jeb.core.output.text.impl.Anchor;
import com.pnfsoftware.jeb.core.output.text.impl.Coordinates;
import com.pnfsoftware.jeb.core.output.text.impl.Line;
import com.pnfsoftware.jeb.core.output.text.impl.TextItem;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.corei.parsers.utf8.Hl;
import com.pnfsoftware.jeb.corei.parsers.utf8.Vw;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import java.util.ArrayList;
import java.util.List;

@SerDisabled
public class Qb
extends AbstractTextDocument {
    private static final ILogger ce = GlobalLog.getLogger(Qb.class);
    private Vw mm;
    private static final int fz = 20;
    private int Rs;

    public Qb(Vw vw) {
        this.mm = vw;
        List<String> list = vw.ce();
        this.Rs = (list.size() + 20 - 1) / 20;
    }

    public Vw ce() {
        return this.mm;
    }

    @Override
    public ICoordinates addressToCoordinates(String string, CoordinatesConversionPrecision coordinatesConversionPrecision) {
        int n2;
        int n3;
        String[] stringArray = string.split(",");
        if (stringArray.length != 2) {
            return null;
        }
        try {
            n3 = Integer.parseInt(stringArray[0]);
            n2 = Integer.parseInt(stringArray[1]);
        }
        catch (Exception exception) {
            return null;
        }
        return new Coordinates(n3 / 20, n3 % 20, n2);
    }

    @Override
    public String coordinatesToAddress(ICoordinates iCoordinates, AddressConversionPrecision addressConversionPrecision) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(iCoordinates.getAnchorId() * 20L + (long)iCoordinates.getLineDelta()).append(',');
        stringBuilder.append(iCoordinates.getColumnOffset());
        return stringBuilder.toString();
    }

    @Override
    public long getAnchorCount() {
        return this.Rs;
    }

    @Override
    public ITextDocumentPart getDocumentPart(long l2, int n2, int n3) {
        int n4 = (int)l2;
        if (n4 < 0 || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException();
        }
        ce.info("Requesting lines: id=%d, after=%d, before=%d", n4, n2, n3);
        int n5 = n4 - (n3 + 20 - 1) / 20;
        int n6 = n4 + n2 / 20;
        if (n5 < 0) {
            n5 = 0;
        }
        if (n6 >= this.Rs) {
            n6 = this.Rs - 1;
        }
        ArrayList<IAnchor> arrayList = new ArrayList<IAnchor>();
        ArrayList<ILine> arrayList2 = new ArrayList<ILine>();
        List<String> list = this.mm.ce();
        int n7 = n5 * 20;
        int n8 = 0;
        for (int i = n5; i <= n6; ++i) {
            Anchor anchor = new Anchor(i, n8);
            arrayList.add(anchor);
            int n9 = 0;
            for (int j = n7; j < n7 + 20 && j < list.size(); ++j) {
                String string = list.get(j);
                ArrayList<TextItem> arrayList3 = new ArrayList<TextItem>();
                if (string.length() >= 10) {
                    arrayList3.add(new TextItem(0, 5, ItemClassIdentifiers.CLASS_NAME, 1L, 0));
                }
                arrayList2.add(new Line(string, arrayList3));
                ++n9;
            }
            n7 += n9;
            n8 += n9;
        }
        return new Hl(arrayList, arrayList2);
    }

    @Override
    public /* synthetic */ IUnit getUnit() {
        return this.ce();
    }
}

