/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.tar;

import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.corei.parsers.tar.ri;
import java.nio.ByteBuffer;
import java.util.Map;

public class TarIdentifier
extends AbstractUnitIdentifier {
    public static final String TYPE = "tar";

    public TarIdentifier() {
        super(TYPE, 0.0);
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("Tar archive handler", "Tar file inflater based on Apache commons-compress", "PNF Software", Version.create(0, 1, 0));
    }

    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator, String string, Map<Object, Object> map) {
        if (iInput == null) {
            return false;
        }
        if (string != null && string.endsWith(".tar")) {
            return true;
        }
        ByteBuffer byteBuffer = iInput.getHeader();
        if (byteBuffer.limit() < 512) {
            return false;
        }
        byte[] byArray = TarIdentifier.convert(byteBuffer);
        if (byArray[99] != 0) {
            return false;
        }
        if (!(TarIdentifier.isAsciiOctal(byArray, 100, 8) && TarIdentifier.isAsciiOctal(byArray, 108, 8) && TarIdentifier.isAsciiOctal(byArray, 116, 8))) {
            return false;
        }
        return TarIdentifier.isAsciiOctal(byArray, 136, 12);
    }

    private static boolean isAsciiOctal(byte[] byArray, int n2, int n3) {
        for (int i = 0; i < n3 - 1; ++i) {
            if (byArray[n2 + i] >= 48 && byArray[n2 + i] <= 55) continue;
            return false;
        }
        return byArray[n2 + n3 - 1] == 0;
    }

    private static byte[] convert(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        return byArray;
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, Map<Object, Object> map) {
        ri ri2 = new ri(string, iInput, iUnitProcessor, iUnitCreator, this.pdm);
        return ri2;
    }
}

