/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.simatic;

import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.IInstructionOperand;
import com.pnfsoftware.jeb.core.units.code.simatic.S7;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.math.MathUtil;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
public class mo
implements IInstructionOperand {
    private static final String[] ce = new String[]{"P", "I", "Q", "M", "DB", "DI", "L", "V"};
    private static final String[] mm = new String[]{"P", "I", "Q", "M", "DBX", "DIX", "L", "V"};
    @SerId(value=1)
    private int fz;
    @SerId(value=2)
    private int Rs;
    @SerId(value=3)
    private int ok;

    public mo(int n2) {
        this(n2, 0);
    }

    public mo(int n2, int n3) {
        this(n2, n3, 0);
    }

    public mo(int n2, int n3, int n4) {
        if (n2 == 0) {
            throw new IllegalArgumentException();
        }
        this.fz = n2;
        this.Rs = n3;
        this.ok = n4;
    }

    public int ce() {
        return this.fz & 0xF00;
    }

    public int mm() {
        return this.fz & 0xFF;
    }

    public int fz() {
        return this.Rs;
    }

    public boolean Rs() {
        return this.ce() == 512;
    }

    public int ok() {
        return this.ok & 0xFF;
    }

    public int[] mH() {
        Assert.a(this.Rs() && this.ok() == 32 || this.ok() == 33);
        return new int[]{this.Rs >>> 24 & 0xFF, this.Rs >>> 3 & 0x1FFFFF, this.Rs & 7};
    }

    public boolean tA() {
        return this.ce() == 768;
    }

    public boolean hG() {
        return this.mm() == 24;
    }

    public int ZQ() {
        return this.fz;
    }

    public int lg() {
        return this.ok;
    }

    public long ce(long l2) {
        if (this.ce() == 768) {
            return l2 + (long)(2 * this.Rs);
        }
        if (this.ce() == 1024) {
            return l2 + (long)(4 * (this.Rs + 1));
        }
        return 0L;
    }

    public int[] ch() {
        Assert.a(this.ce() == 256);
        int n2 = (this.fz & 0xF00000) >>> 20;
        return new int[]{this.Rs, n2};
    }

    public int UE() {
        switch (this.fz & 0xF000) {
            case 16384: {
                return 1;
            }
            case 4096: {
                return 8;
            }
            case 8192: {
                return 16;
            }
            case 12288: {
                return 32;
            }
        }
        return 0;
    }

    @Override
    public String format(IInstruction iInstruction, long l2) {
        int n2 = this.fz & 0xF00;
        if (n2 == 1280) {
            return "0";
        }
        if (n2 == 1536) {
            return "1";
        }
        if (n2 == 768 || n2 == 1024) {
            long l3 = this.ce(l2);
            return Strings.ff("0x%X", l3);
        }
        boolean bl = n2 == 1792;
        StringBuilder stringBuilder = new StringBuilder();
        String string = iInstruction == null ? null : iInstruction.getMnemonic();
        this.ce(this.fz, string, bl, stringBuilder);
        this.mm(this.fz, stringBuilder);
        if (n2 == 512) {
            this.ce(stringBuilder);
            stringBuilder.append("[");
            if (!this.ce(this.ok, stringBuilder)) {
                this.ce(this.ok, string, false, stringBuilder);
            }
            this.mm(this.ok, stringBuilder);
            int n3 = this.lj();
            this.ce(this.Rs, n3, this.fz, stringBuilder);
            stringBuilder.append("]");
        } else {
            int n4 = this.lj();
            if (n4 > 0) {
                this.ce(this.Rs, n4, this.fz, stringBuilder);
            }
        }
        return stringBuilder.toString();
    }

    private void ce(int n2, String string, boolean bl, StringBuilder stringBuilder) {
        int n3 = n2 & 0xFF;
        switch (n3) {
            case 0: {
                break;
            }
            case 16: {
                stringBuilder.append(mo.ce(string));
                break;
            }
            case 1: {
                stringBuilder.append("I");
                break;
            }
            case 2: {
                stringBuilder.append("Q");
                break;
            }
            case 3: {
                stringBuilder.append("M");
                break;
            }
            case 4: {
                stringBuilder.append("DB");
                break;
            }
            case 5: {
                stringBuilder.append("DI");
                break;
            }
            case 6: {
                stringBuilder.append("L");
                break;
            }
            case 7: {
                stringBuilder.append("V");
                break;
            }
            case 8: {
                stringBuilder.append("T");
                break;
            }
            case 9: {
                stringBuilder.append("C");
                break;
            }
            case 10: {
                stringBuilder.append("FC");
                break;
            }
            case 11: {
                stringBuilder.append("FB");
                break;
            }
            case 12: {
                stringBuilder.append("SFC");
                break;
            }
            case 13: {
                stringBuilder.append("SFB");
                break;
            }
            case 15: {
                stringBuilder.append("OB");
                break;
            }
            case 24: {
                stringBuilder.append("STW");
                break;
            }
            case 32: {
                stringBuilder.append("AR1");
                break;
            }
            case 33: {
                stringBuilder.append("AR2");
                break;
            }
            case 34: {
                stringBuilder.append("DBLG");
                break;
            }
            case 35: {
                stringBuilder.append("DILG");
                break;
            }
            case 36: {
                if ("OPN".equals(string)) {
                    stringBuilder.append("DB");
                    break;
                }
                stringBuilder.append("DBNO");
                break;
            }
            case 37: {
                if ("OPN".equals(string)) {
                    stringBuilder.append("DI");
                    break;
                }
                stringBuilder.append("DINO");
                break;
            }
            case 25: {
                stringBuilder.append("OS");
                break;
            }
            case 26: {
                stringBuilder.append("OV");
                break;
            }
            case 27: {
                stringBuilder.append("UO");
                break;
            }
            case 28: {
                stringBuilder.append("BR");
                break;
            }
            case 49: {
                stringBuilder.append(">0");
                break;
            }
            case 50: {
                stringBuilder.append("<0");
                break;
            }
            case 51: {
                stringBuilder.append("<>0");
                break;
            }
            case 52: {
                stringBuilder.append("==0");
                break;
            }
            case 53: {
                stringBuilder.append(">=0");
                break;
            }
            case 54: {
                stringBuilder.append("<=0");
                break;
            }
            case 64: {
                stringBuilder.append("PARAM_UNKNOWN?");
                break;
            }
            case 65: {
                stringBuilder.append("PARAM_BOOL");
                break;
            }
            case 66: {
                stringBuilder.append("PARAM_BYTE");
                break;
            }
            case 67: {
                stringBuilder.append("PARAM_WORD");
                break;
            }
            case 68: {
                stringBuilder.append("PARAM_DWORD");
                break;
            }
            case 74: {
                stringBuilder.append("PARAM_REF");
                break;
            }
            default: {
                throw new RuntimeException(Strings.ff("TBI: Format for operand: 0x%X", n3));
            }
        }
    }

    public static String ce(int n2, String string) {
        switch (n2) {
            case 16: {
                return mo.ce(string);
            }
            case 1: {
                return "I";
            }
            case 2: {
                return "Q";
            }
            case 3: {
                return "M";
            }
            case 4: {
                return "DB";
            }
            case 5: {
                return "DI";
            }
            case 6: {
                return "L";
            }
            case 7: {
                return "V";
            }
            case 8: {
                return "T";
            }
            case 9: {
                return "C";
            }
        }
        return null;
    }

    private boolean ce(int n2, StringBuilder stringBuilder) {
        switch (n2 & 0xFF) {
            case 32: {
                stringBuilder.append("AR1, ");
                return true;
            }
            case 33: {
                stringBuilder.append("AR2, ");
                return true;
            }
        }
        return false;
    }

    private void mm(int n2, StringBuilder stringBuilder) {
        switch (n2 & 0xF000) {
            case 0: {
                break;
            }
            case 4096: {
                stringBuilder.append("B");
                break;
            }
            case 8192: {
                stringBuilder.append("W");
                break;
            }
            case 12288: {
                stringBuilder.append("D");
                break;
            }
            case 16384: {
                int n3 = n2 & 0xFF;
                if (n3 != 4 && n3 != 5) break;
                stringBuilder.append("X");
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    public int lj() {
        return this.ce(this.fz);
    }

    private int ce(int n2) {
        switch (n2 & 0xF0000) {
            case 262144: {
                return 7;
            }
            case 65536: 
            case 524288: {
                return 8;
            }
            case 131072: 
            case 393216: {
                return 16;
            }
            case 196608: {
                return 32;
            }
        }
        return 0;
    }

    private void ce(int n2, int n3, int n4, StringBuilder stringBuilder) {
        this.ce(stringBuilder);
        if (this.ce() == 1792) {
            this.ZQ(n2, n3, stringBuilder);
            return;
        }
        switch (n4 & 0xF0000000) {
            case 0x10000000: {
                this.ce(n2, n3, stringBuilder);
                break;
            }
            case 0x20000000: {
                this.mm(n2, n3, stringBuilder);
                break;
            }
            case 0x30000000: {
                this.fz(n2, n3, stringBuilder);
                break;
            }
            case 0x40000000: {
                this.tA(n2, n3, stringBuilder);
                break;
            }
            case 0x50000000: {
                this.hG(n2, n3, stringBuilder);
                break;
            }
            case 0x60000000: {
                this.Rs(n2, n3, stringBuilder);
                break;
            }
            case 0x70000000: {
                this.ok(n2, n3, stringBuilder);
                break;
            }
            case -2147483648: {
                this.mH(n2, n3, stringBuilder);
                break;
            }
            case -1879048192: {
                this.lg(n2, n3, stringBuilder);
                break;
            }
            case -1610612736: {
                this.UE(n2, n3, stringBuilder);
                break;
            }
            case -1342177280: {
                this.ch(n2, n3, stringBuilder);
                break;
            }
            case -1073741824: {
                this.lj(n2, n3, stringBuilder);
                break;
            }
            default: {
                stringBuilder.append(n2);
            }
        }
        if ((n4 & 0xF00) == 256) {
            int n5 = (n4 & 0xF00000) >>> 20;
            stringBuilder.append(".").append(n5);
        }
    }

    private void ce(StringBuilder stringBuilder) {
        if (stringBuilder.length() == 0) {
            return;
        }
        char c2 = stringBuilder.charAt(stringBuilder.length() - 1);
        if (c2 == ' ' || c2 == '[' || c2 == '#') {
            return;
        }
        stringBuilder.append(' ');
    }

    private void ce(int n2, int n3, StringBuilder stringBuilder) {
        Assert.a(n3 == 32);
        Strings.ff(stringBuilder, "%.6f", Float.valueOf(Float.intBitsToFloat(n2)));
    }

    private void mm(int n2, int n3, StringBuilder stringBuilder) {
        stringBuilder.append("2#");
        if (n2 == 0) {
            stringBuilder.append('0');
        } else {
            StringBuilder stringBuilder2 = new StringBuilder();
            while (n2 != 0) {
                char c2 = (n2 & 1) == 0 ? (char)'0' : '1';
                stringBuilder2.insert(0, c2);
                n2 >>>= 1;
            }
            stringBuilder.append((CharSequence)stringBuilder2);
        }
    }

    private void fz(int n2, int n3, StringBuilder stringBuilder) {
        if (n3 == 8) {
            stringBuilder.append(MathUtil.signExtend32(n2, 8));
        } else if (n3 == 16) {
            stringBuilder.append(MathUtil.signExtend32(n2, 16));
        } else if (n3 == 32) {
            stringBuilder.append("L#");
            stringBuilder.append(n2);
        } else {
            Assert.fail();
        }
    }

    private void Rs(int n2, int n3, StringBuilder stringBuilder) {
        if (n3 == 16) {
            int n4 = n2 >> 8 & 0xFF;
            int n5 = n2 & 0xFF;
            Strings.ff(stringBuilder, "B#(%d, %d)", n4, n5);
        } else if (n3 == 32) {
            int n6 = n2 >> 24 & 0xFF;
            int n7 = n2 >> 16 & 0xFF;
            int n8 = n2 >> 8 & 0xFF;
            int n9 = n2 & 0xFF;
            Strings.ff(stringBuilder, "B#(%d, %d, %d, %d)", n6, n7, n8, n9);
        } else {
            Assert.fail();
        }
    }

    private void ok(int n2, int n3, StringBuilder stringBuilder) {
        if (n3 == 32) {
            stringBuilder.append("DW");
        } else if (n3 == 16) {
            stringBuilder.append('W');
        } else if (n3 == 8) {
            stringBuilder.append('B');
        }
        Strings.ff(stringBuilder, "#16#%X", n2);
    }

    private void mH(int n2, int n3, StringBuilder stringBuilder) {
        Assert.a(n3 == 16);
        int n4 = n2 >> 8 & 0xF;
        int n5 = n2 >> 4 & 0xF;
        int n6 = n2 & 0xF;
        if (n4 == 0) {
            if (n5 == 0) {
                Strings.ff(stringBuilder, "C#%d", n6);
            } else {
                Strings.ff(stringBuilder, "C#%d%d", n5, n6);
            }
        } else {
            Strings.ff(stringBuilder, "C#%d%d%d", n4, n5, n6);
        }
    }

    private void tA(int n2, int n3, StringBuilder stringBuilder) {
        int n4;
        Object object;
        int n5 = n2 >>> 24;
        if (n5 == 0) {
            object = "";
        } else {
            Assert.a((n5 & 0x80) == 128);
            n4 = n5 & 0x7F;
            object = mm[n4] + " ";
        }
        n4 = n2 >>> 3 & 0x1FFFFF;
        int n6 = n2 & 7;
        Strings.ff(stringBuilder, "P#%s%d.%d", object, n4, n6);
    }

    private void hG(int n2, int n3, StringBuilder stringBuilder) {
        if (n3 == 8) {
            char c2 = (char)(n2 & 0xFF);
            Strings.ff(stringBuilder, "'%c'", Character.valueOf(c2));
        } else if (n3 == 16) {
            char c3 = (char)(n2 & 0xFF);
            char c4 = (char)(n2 >> 8 & 0xFF);
            if (c4 == '\u0000') {
                Strings.ff(stringBuilder, "'%c'", Character.valueOf(c3));
            } else {
                Strings.ff(stringBuilder, "'%c%s'", Character.valueOf(c4), Character.valueOf(c3));
            }
        } else if (n3 == 32) {
            char c5 = (char)(n2 & 0xFF);
            char c6 = (char)(n2 >> 8 & 0xFF);
            char c7 = (char)(n2 >> 16 & 0xFF);
            char c8 = (char)(n2 >> 24 & 0xFF);
            if (c6 == '\u0000') {
                Strings.ff(stringBuilder, "'%c'", Character.valueOf(c5));
            } else if (c7 == '\u0000') {
                Strings.ff(stringBuilder, "'%c%c'", Character.valueOf(c6), Character.valueOf(c5));
            } else if (c8 == '\u0000') {
                Strings.ff(stringBuilder, "'%c%c%c'", Character.valueOf(c7), Character.valueOf(c6), Character.valueOf(c5));
            } else {
                Strings.ff(stringBuilder, "'%c%c%c%c'", Character.valueOf(c8), Character.valueOf(c7), Character.valueOf(c6), Character.valueOf(c5));
            }
        } else {
            throw new RuntimeException();
        }
    }

    private void ZQ(int n2, int n3, StringBuilder stringBuilder) {
        Strings.ff(stringBuilder, "Z#%d", n2);
    }

    private void lg(int n2, int n3, StringBuilder stringBuilder) {
        Assert.a(n3 == 32);
        stringBuilder.append(S7.Time.create(n2).toString());
    }

    private void ch(int n2, int n3, StringBuilder stringBuilder) {
        stringBuilder.append(S7.TimeOfDay.create(n2));
    }

    private void UE(int n2, int n3, StringBuilder stringBuilder) {
        stringBuilder.append(S7.Date.create(n2));
    }

    private void lj(int n2, int n3, StringBuilder stringBuilder) {
        stringBuilder.append(S7.S5Time.create(n2).toString());
    }

    private static String ce(String string) {
        if (string != null) {
            switch (string) {
                case "L": {
                    return "PI";
                }
                case "T": {
                    return "PQ";
                }
            }
        }
        return "E";
    }
}

