/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.simatic;

import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.JebCoreService;
import com.pnfsoftware.jeb.core.input.BytesInput;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.AbstractUnit;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.code.simatic.IS7Block;
import com.pnfsoftware.jeb.core.units.code.simatic.IS7Unit;
import com.pnfsoftware.jeb.core.units.code.simatic.S7;
import com.pnfsoftware.jeb.core.units.codeobject.AbstractCodeObjectUnit;
import com.pnfsoftware.jeb.core.units.codeobject.ILinkInfoProvider;
import com.pnfsoftware.jeb.core.units.codeobject.ILoaderInformation;
import com.pnfsoftware.jeb.core.units.codeobject.ISegmentInformation;
import com.pnfsoftware.jeb.core.units.codeobject.LoaderInformation;
import com.pnfsoftware.jeb.core.units.codeobject.SegmentInformation;
import com.pnfsoftware.jeb.core.units.codeobject.SymbolInformation;
import com.pnfsoftware.jeb.core.units.codeobject.SymbolType;
import com.pnfsoftware.jeb.core.units.impl.ContainerUnit;
import com.pnfsoftware.jeb.corei.parsers.simatic.Cg;
import com.pnfsoftware.jeb.corei.parsers.simatic.Fd;
import com.pnfsoftware.jeb.corei.parsers.simatic.YM;
import com.pnfsoftware.jeb.corei.parsers.simatic.cI;
import com.pnfsoftware.jeb.corei.parsers.simatic.lc;
import com.pnfsoftware.jeb.corei.parsers.simatic.rs;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.base.Throwables;
import com.pnfsoftware.jeb.util.collect.BytePipe;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.Endianness;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

@Ser
public class kn
extends AbstractCodeObjectUnit
implements IS7Unit {
    private static final ILogger ok = GlobalLog.getLogger(kn.class);
    private static final long mH = 0x100000L;
    private static final String tA = ".blk_";
    private static final String hG = ".code_";
    private static final String ZQ = ".data_";
    private static final String lg = ".globals";
    private static final String ch = ".inputs";
    private static final String UE = ".outputs";
    private static final String lj = ".counters";
    private static final String Wz = ".timers";
    @SerId(value=1)
    byte[] ce;
    @SerId(value=2)
    List<IS7Block> mm = new ArrayList<IS7Block>();
    @SerId(value=3)
    Map<String, String> fz = new HashMap<String, String>();
    @SerId(value=4)
    Map<Long, IS7Block> Rs = new HashMap<Long, IS7Block>();
    private static final Map<S7.BlockType, Integer> LS = new HashMap<S7.BlockType, Integer>();
    @SerTransient
    private Map<String, Fd> oW = new HashMap<String, Fd>();

    public kn(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, IPropertyDefinitionManager iPropertyDefinitionManager) {
        super(iInput, "simatic_s7", string, iUnitProcessor, iUnitCreator, iPropertyDefinitionManager);
    }

    @Override
    public List<IS7Block> getBlocks() {
        return Collections.unmodifiableList(this.mm);
    }

    @Override
    public IS7Block findBlock(S7.BlockType blockType, int n2) {
        for (IS7Block iS7Block : this.mm) {
            if (iS7Block.getType() != blockType || iS7Block.getNumber() != n2) continue;
            return iS7Block;
        }
        return null;
    }

    @Override
    public String getBlockEntryName(IS7Block iS7Block) {
        return this.fz.get(iS7Block.getName());
    }

    public boolean ce() {
        return AbstractUnitIdentifier.checkBytes(this.getInput(), 0, 80, 75, 3, 4);
    }

    @Override
    protected boolean processInternal() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        block34: {
            if (this.ce()) {
                try {
                    object5 = new ZipFile(this.getInput().getChannel());
                    try {
                        object4 = object5.getEntries();
                        while (object4.hasMoreElements()) {
                            object3 = (ZipArchiveEntry)object4.nextElement();
                            if (object3.isDirectory() || !object5.canReadEntryData((ZipArchiveEntry)object3)) continue;
                            try {
                                object2 = IO.readInputStream(object5.getInputStream((ZipArchiveEntry)object3));
                                object = this.ce((byte[])object2);
                                if (object == null) continue;
                                this.fz.put(object.getName(), object3.getName());
                            }
                            catch (IOException iOException) {
                                ok.catching(iOException);
                            }
                        }
                        break block34;
                    }
                    finally {
                        object5.close();
                    }
                }
                catch (IOException iOException) {
                    ok.catchingSilent(iOException);
                    return false;
                }
            }
            try {
                object5 = this.getInput().getStream();
                try {
                    object4 = IO.readInputStream((InputStream)object5);
                    this.ce((byte[])object4);
                }
                finally {
                    if (object5 != null) {
                        ((InputStream)object5).close();
                    }
                }
            }
            catch (IOException iOException) {
                ok.catchingSilent(iOException);
                return false;
            }
        }
        this.mm();
        if (this.mm.isEmpty()) {
            return false;
        }
        this.fz();
        object5 = new LoaderInformation.Builder().setFlags(0).setVersion("1").setTargetProcessor(lc.mm).setWordSize(32).setEndianness(Endianness.BIG_ENDIAN).setImageBase(0x100000L).setImageSize(this.ce.length).setEntryPoint(0L).build();
        this.setLoaderInformation((ILoaderInformation)object5);
        if (this.getPropertyManager().getBoolean("DisassembleCode")) {
            try {
                object4 = "simatic_mc7";
                object3 = this.getUnitProcessor().process((String)object4 + " image", this.getInput(), this, (String)object4, true);
                if (object3 != null) {
                    this.addChildUnit((IUnit)object3);
                }
            }
            catch (Exception exception) {
                ok.catching(exception);
            }
        }
        if (this.getPropertyManager().getBoolean("GenerateInterfaceDescriptionUnits")) {
            object4 = new ContainerUnit("Interfaces", this.getUnitProcessor(), this, this.getPropertyDefinitionManager());
            ((ContainerUnit)object4).process();
            this.addChild((IUnit)object4);
            object3 = this.mm.iterator();
            while (object3.hasNext()) {
                Object object6;
                object2 = (IS7Block)object3.next();
                object = new StringBuilder();
                try {
                    object6 = this.ce((IS7Block)object2);
                    Strings.ff((Appendable)object, "Interface and initial values for block %s:\n", object2.getName());
                    ((StringBuilder)object).append(((Fd)object6).mH());
                    ((StringBuilder)object).append('\n');
                    try {
                        if (object2.getType().isDataBlock()) {
                            byte[] byArray = new cI().ce((Fd)object6);
                            byte[] byArray2 = object2.getPayloadBytes();
                            if (byArray != null && !Arrays.equals(byArray, byArray2)) {
                                ((StringBuilder)object).append("\nIMPORTANT! The current values stored in this data block differ from the initial values.\n");
                                boolean bl = this.getPropertyManager().getBoolean("MapActualBytesForDataBlocks");
                                Strings.ff((Appendable)object, "The %s values will be used for mapping in the code unit ('simatic_mc7 image' node).\n", bl ? "current" : "initial");
                            }
                            Strings.ff((Appendable)object, "\nCurrent values for data block %s:\n", object2.getName());
                            ((StringBuilder)object).append(((Fd)object6).mm(byArray2));
                            ((StringBuilder)object).append('\n');
                        }
                    }
                    catch (Exception exception) {
                        ((StringBuilder)object).append("An error occurred when processing the current values of a data block:\n");
                        ((StringBuilder)object).append(Throwables.formatStacktrace(exception));
                    }
                }
                catch (Exception exception) {
                    ((StringBuilder)object).append("An error occurred when processing the block interface:\n");
                    ((StringBuilder)object).append(Throwables.formatStacktrace(exception));
                }
                object6 = this.getUnitProcessor().process(object2.getName() + " interface", new BytesInput(Strings.encodeUTF8(((StringBuilder)object).toString())), (IUnitCreator)object4, "text");
                ((AbstractUnit)object4).addChild((IUnit)object6);
            }
        }
        try {
            JebCoreService.notifyTelemetryToClient("s7_unit_processed", "block_count", "" + this.mm.size());
        }
        catch (Exception exception) {}
        return true;
    }

    private IS7Block ce(byte[] byArray) {
        IS7Block iS7Block;
        if (!rs.ce(byArray)) {
            return null;
        }
        try {
            iS7Block = rs.mm(byArray);
        }
        catch (Exception exception) {
            return null;
        }
        if (iS7Block.getType() == S7.BlockType.UNKNOWN || iS7Block.getSourceLanguage() == S7.LangType.UNKNOWN) {
            this.ce(null, iS7Block, "Unsupported block type or language (type: %d, lang: %d)", iS7Block.getTypeId(), iS7Block.getSourceLanguageId());
        }
        this.mm.add(iS7Block);
        return iS7Block;
    }

    private int mm() {
        int n2 = 0;
        HashSet<String> hashSet = new HashSet<String>();
        Iterator<IS7Block> iterator = this.mm.iterator();
        while (iterator.hasNext()) {
            IS7Block iS7Block = iterator.next();
            S7.BlockType blockType = S7.BlockType.fromId(iS7Block.getTypeId());
            if (blockType == null) {
                ok.warn("Removing block of unknown type id: " + iS7Block.getTypeId(), new Object[0]);
                iterator.remove();
                ++n2;
                continue;
            }
            int n3 = iS7Block.getNumber();
            if (n3 == 0) {
                ok.warn("A block has id 0!", new Object[0]);
                continue;
            }
            String string = iS7Block.getName();
            if (hashSet.add(string)) continue;
            ok.warn("Removing duplicate block: " + string, new Object[0]);
            iterator.remove();
            ++n2;
        }
        this.mm.sort(new YM(this));
        return n2;
    }

    private int ce(int n2, BytePipe bytePipe) {
        int n3 = bytePipe.limit();
        int n4 = n3 % n2;
        if (n4 == 0) {
            return 0;
        }
        int n5 = n2 - n4;
        bytePipe.append(new byte[n5]);
        return n5;
    }

    private void fz() {
        int n2;
        BytePipe bytePipe = new BytePipe();
        if (this.getPropertyManager().getBoolean("MapRawBlocksAtZero")) {
            for (IS7Block iS7Block : this.mm) {
                n2 = bytePipe.limit();
                int n3 = iS7Block.getBlockSize();
                this.addSegment(new SegmentInformation(this.ce(iS7Block.getType(), iS7Block.getNumber()), n2, n3, n2, n3, 2));
                bytePipe.append(iS7Block.getBlockBytes());
                this.ce(16, bytePipe);
            }
        } else {
            int n4 = bytePipe.limit();
            int n5 = 16;
            this.addSegment(new SegmentInformation(".slack", n4, n5, n4, n5, 2));
            bytePipe.append(new byte[n5]);
            this.ce(16, bytePipe);
        }
        for (IS7Block iS7Block : this.mm) {
            boolean bl;
            if (!iS7Block.getType().isLogicBlock()) continue;
            n2 = bytePipe.limit();
            byte[] byArray = iS7Block.getPayloadBytes();
            boolean bl2 = bl = byArray.length >= 2 && byArray[byArray.length - 2] == 101 && (byArray[byArray.length - 1] & 0xFE) == 0;
            if (!bl) {
                byArray = Arrays.copyOf(byArray, byArray.length + 2);
                byArray[byArray.length - 2] = 101;
                byArray[byArray.length - 1] = 1;
                this.ce(null, iS7Block, "Code does not end with BE/BEU", new Object[0]);
            }
            int n6 = byArray.length;
            this.addSegment(new SegmentInformation(this.mm(iS7Block.getType(), iS7Block.getNumber()), n2, n6, n2, n6, 6));
            bytePipe.append(byArray);
            String string = "func_" + iS7Block.getName();
            if (!Strings.isBlank(iS7Block.getMetadataBlockName())) {
                string = string + "_" + iS7Block.getMetadataBlockName();
            }
            this.addSymbol(new SymbolInformation(SymbolType.FUNCTION, 0, 0L, string, 0L, n2, 0L));
            this.Rs.put(0x100000L + (long)n2, iS7Block);
        }
        this.ce(65536, bytePipe);
        boolean bl = this.getPropertyManager().getBoolean("MapActualBytesForDataBlocks");
        for (IS7Block iS7Block : this.mm) {
            Object object;
            byte[] byArray;
            if (!iS7Block.getType().isDataBlock()) continue;
            if (bl) {
                byArray = iS7Block.getPayloadBytes();
            } else {
                try {
                    object = this.ce(iS7Block);
                    byArray = new cI().ce((Fd)object);
                }
                catch (Exception exception) {
                    byArray = new byte[]{};
                }
            }
            object = Arrays.copyOf(byArray, 65536);
            int n7 = bytePipe.limit();
            int n8 = 65536;
            this.addSegment(new SegmentInformation(this.fz(iS7Block.getType(), iS7Block.getNumber()), n7, n8, n7, n8, 3));
            bytePipe.append((byte[])object);
            this.Rs.put(0x100000L + (long)n7, iS7Block);
        }
        Object object = new byte[65536];
        int n9 = ((Object)object).length;
        int n10 = bytePipe.limit();
        this.addSegment(new SegmentInformation(lg, n10, n9, n10, n9, 3));
        bytePipe.append((byte[])object, 0, n9);
        n9 = ((Object)object).length;
        n10 = bytePipe.limit();
        this.addSegment(new SegmentInformation(ch, n10, n9, n10, n9, 3));
        bytePipe.append((byte[])object, 0, n9);
        n9 = ((Object)object).length;
        n10 = bytePipe.limit();
        this.addSegment(new SegmentInformation(UE, n10, n9, n10, n9, 3));
        bytePipe.append((byte[])object, 0, n9);
        n9 = 512;
        n10 = bytePipe.limit();
        this.addSegment(new SegmentInformation(lj, n10, n9, n10, n9, 3));
        bytePipe.append((byte[])object, 0, n9);
        n9 = 512;
        n10 = bytePipe.limit();
        this.addSegment(new SegmentInformation(Wz, n10, n9, n10, n9, 3));
        bytePipe.append((byte[])object, 0, n9);
        this.ce = bytePipe.getAll();
    }

    String ce(S7.BlockType blockType, int n2) {
        return tA + Cg.ce(blockType, n2);
    }

    @Override
    public long getAddressOfRawBytes(IS7Block iS7Block) {
        return this.ce(this.ce(iS7Block.getType(), iS7Block.getNumber()));
    }

    @Override
    public IS7Block getBlockAt(long l2) {
        return this.Rs.get(l2);
    }

    @Override
    public IS7Block getBlockContaining(long l2) {
        if ((l2 -= 0x100000L) >= 0L) {
            for (ISegmentInformation iSegmentInformation : this.getSegments()) {
                long l3;
                if (!Strings.startsWith(iSegmentInformation.getName(), hG, ZQ) || l2 < (l3 = iSegmentInformation.getOffsetInMemory()) || l2 >= l3 + iSegmentInformation.getSizeInMemory()) continue;
                return this.getBlockAt(l3);
            }
        }
        return null;
    }

    String mm(S7.BlockType blockType, int n2) {
        Assert.a(blockType.isLogicBlock());
        return hG + Cg.ce(blockType, n2);
    }

    @Override
    public long getAddressOfCode(S7.BlockType blockType, int n2) {
        return this.ce(this.mm(blockType, n2));
    }

    String fz(S7.BlockType blockType, int n2) {
        Assert.a(blockType.isDataBlock());
        return ZQ + Cg.ce(blockType, n2);
    }

    @Override
    public long getAddressOfData(S7.BlockType blockType, int n2) {
        return this.ce(this.fz(blockType, n2));
    }

    @Override
    public long getAddressOfGlobals() {
        return this.ce(lg);
    }

    @Override
    public long getAddressOfDigitalInputs() {
        return this.ce(ch);
    }

    @Override
    public long getAddressOfDigitalOutputs() {
        return this.ce(UE);
    }

    @Override
    public long getAddressOfCounters() {
        return this.ce(lj);
    }

    @Override
    public long getAddressOfTimers() {
        return this.ce(Wz);
    }

    private long ce(String string) {
        for (ISegmentInformation iSegmentInformation : this.getSegments()) {
            if (!iSegmentInformation.getName().equals(string)) continue;
            return 0x100000L + iSegmentInformation.getOffsetInMemory();
        }
        return -1L;
    }

    @Override
    protected IInput getMappableInput() {
        return new BytesInput(this.ce);
    }

    @Override
    protected boolean shouldAllocateFullImage() {
        return false;
    }

    @Override
    protected boolean applyRelocations(IVirtualMemory iVirtualMemory, long l2, ILinkInfoProvider iLinkInfoProvider) {
        return false;
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder(super.getDescription());
        stringBuilder.append('\n');
        Strings.ff(stringBuilder, "Mapping of %d S7 blocks:\n", this.mm.size());
        for (IS7Block iS7Block : this.mm) {
            Strings.ff(stringBuilder, "- %s\n", iS7Block);
        }
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }

    @Override
    public byte[] getIconData() {
        byte[] byArray;
        block8: {
            InputStream inputStream = this.getClass().getResourceAsStream("assets/s7_block.png");
            try {
                byArray = IO.readInputStream(inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            inputStream.close();
        }
        return byArray;
    }

    public Fd ce(IS7Block iS7Block) {
        String string = iS7Block.getName();
        Fd fd = this.oW.get(string);
        if (fd == null) {
            kn kn2 = this;
            synchronized (kn2) {
                fd = this.oW.get(string);
                if (fd == null) {
                    try {
                        fd = Fd.ce(iS7Block.getInterfaceBytes());
                    }
                    catch (Exception exception) {
                        this.ce(exception, iS7Block, "Failed parsing interface", new Object[0]);
                    }
                    this.oW.put(string, fd);
                }
            }
        }
        return fd;
    }

    private void ce(Throwable throwable, IS7Block iS7Block, String string, Object ... objectArray) {
        Object object = Strings.ff(string, objectArray);
        if (iS7Block != null) {
            object = iS7Block.getName() + ": " + (String)object;
        }
        RuntimeException runtimeException = throwable == null ? new RuntimeException((String)object) : new RuntimeException((String)object, throwable);
        JebCoreService.notifySilentExceptionToClient((Throwable)runtimeException, this);
    }

    static {
        LS.put(S7.BlockType.OB, 0);
        LS.put(S7.BlockType.FB, 1);
        LS.put(S7.BlockType.FC, 2);
        LS.put(S7.BlockType.SFB, 3);
        LS.put(S7.BlockType.SFC, 4);
        LS.put(S7.BlockType.DI, 5);
        LS.put(S7.BlockType.DB, 6);
        LS.put(S7.BlockType.SDB, 7);
    }
}

