/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.simatic;

import com.pnfsoftware.jeb.core.units.code.CodePointer;
import com.pnfsoftware.jeb.core.units.code.FlowInformation;
import com.pnfsoftware.jeb.core.units.code.IFlowInformation;
import com.pnfsoftware.jeb.core.units.code.IInstructionOperand;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.code.asm.memory.VirtualMemoryUtil;
import com.pnfsoftware.jeb.core.units.code.asm.processor.AbstractInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.processor.BytesBlock;
import com.pnfsoftware.jeb.corei.parsers.simatic.mo;
import com.pnfsoftware.jeb.corei.parsers.simatic.nM;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomInitPostGraph;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.util.ArrayList;
import java.util.List;

@Ser
public class jC
extends AbstractInstruction<mo> {
    @SerTransient
    nM.ri ce;
    @SerId(value=1)
    int mm;

    @SerCustomInitPostGraph
    private void ce() {
        this.ce = nM.ce(this.mm, super.getMnemonic());
    }

    public jC(BytesBlock bytesBlock, nM.ri ri2, mo[] moArray) {
        super(bytesBlock, ri2.fz, (IInstructionOperand[])moArray, 32);
        this.mm = ri2.ce;
        this.ce = ri2;
    }

    @Override
    public String getMnemonic() {
        String string = null;
        switch (this.ce.mm & 0xFF) {
            case 4: {
                int n2 = ((this.getCode()[1] & 0xFF) >>> 5) - 1;
                string = this.ce.tA[n2];
                break;
            }
            case 10: 
            case 13: {
                int n3 = this.getCode()[1] & 0xFF;
                if (n3 >= this.ce.tA.length) break;
                string = this.ce.tA[n3];
                break;
            }
            case 16: {
                int n4 = this.getCode()[1] & 0xFF;
                int n5 = n4 & 7 | (n4 & 0x80) >> 4;
                if (n5 >= this.ce.tA.length) break;
                string = this.ce.tA[n5];
                break;
            }
            case 20: {
                int n6 = this.getCode()[1] & 0xFF;
                string = (n6 & 0x80) == 0 ? "L" : "T";
                break;
            }
            case 22: {
                int n7 = this.getCode()[1] & 0xFF;
                string = (n7 & 4) == 0 ? "L" : "T";
                break;
            }
            case 24: {
                int n8 = this.getCode()[1] & 0xFF;
                int n9 = n8 >> 3 & 0x10 | n8 & 0xF;
                string = this.ce.tA[n9];
            }
        }
        if (string == null) {
            string = super.getMnemonic();
        }
        if (string == null) {
            string = "?";
        }
        return string;
    }

    @Override
    public IFlowInformation getBreakingFlow(long l2) {
        String string;
        switch (string = this.getMnemonic()) {
            case "JU": {
                FlowInformation flowInformation = new FlowInformation();
                int n2 = ((mo)this.getOperand(0)).fz();
                flowInformation.addTarget(new CodePointer(l2 + (long)(2 * n2)));
                return flowInformation;
            }
            case "JL": {
                Assert.a(this.getSize() == 4, "JL expected to be 4 bytes");
                FlowInformation flowInformation = new FlowInformation();
                int n3 = ((mo)this.getOperand(0)).fz();
                for (int i = 1; i <= n3 + 1; ++i) {
                    flowInformation.addTarget(new CodePointer(l2 + (long)(4 * i)));
                }
                return flowInformation;
            }
            case "JC": 
            case "JCN": 
            case "JCB": 
            case "JNB": 
            case "JBI": 
            case "JNBI": 
            case "JO": 
            case "JOS": 
            case "JZ": 
            case "JN": 
            case "JP": 
            case "JM": 
            case "JPZ": 
            case "JMZ": 
            case "JUO": 
            case "LOOP": {
                FlowInformation flowInformation = new FlowInformation();
                int n4 = ((mo)this.getOperand(0)).fz();
                flowInformation.addTarget(new CodePointer(l2 + (long)this.getSize()));
                flowInformation.addTarget(new CodePointer(l2 + (long)(2 * n4)));
                return flowInformation;
            }
            case "BE": 
            case "BEU": {
                return FlowInformation.EMPTY;
            }
        }
        return FlowInformation.NONE;
    }

    @Override
    public IFlowInformation getRoutineCall(long l2) {
        String string;
        switch (string = this.getMnemonic()) {
            case "UC": 
            case "CC": {
                FlowInformation flowInformation = new FlowInformation();
                return flowInformation;
            }
        }
        return FlowInformation.NONE;
    }

    @Override
    public IFlowInformation collectIndirectCallReferences(long l2) {
        return FlowInformation.NONE;
    }

    @Override
    public void getDefUse(List<Integer> list, List<Integer> list2, Object object) {
    }

    @Override
    public boolean canThrow() {
        return false;
    }

    public List<Integer> ce(long l2, IVirtualMemory iVirtualMemory) {
        if (!Strings.isContainedIn(this.getMnemonic(), "UC", "CC")) {
            return null;
        }
        int n2 = ((mo)this.getOperand(0)).mm();
        if (n2 != 10 && n2 != 12) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        long l3 = l2 + (long)this.getSize();
        int[] nArray = new int[1];
        VirtualMemoryUtil.readLEIntSafe(iVirtualMemory, l3, nArray);
        if ((nArray[0] & 0xFFFF) == 2928) {
            int n3 = (nArray[0] >>> 24) + (nArray[0] >>> 8 & 0xFF00);
            int n4 = n3 * 2;
            for (long i = l3 + 4L; i < l3 + (long)n4; i += 4L) {
                if (!VirtualMemoryUtil.readBEIntSafe(iVirtualMemory, i, nArray)) continue;
                arrayList.add(nArray[0]);
            }
        }
        return arrayList;
    }
}

