/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.simatic;

import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeBoolean;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.corei.parsers.simatic.kn;
import com.pnfsoftware.jeb.corei.parsers.simatic.rs;
import com.pnfsoftware.jeb.util.io.IO;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class S7Identifier
extends AbstractUnitIdentifier {
    public static final String TYPE = "simatic_s7";
    public static final String usageManualURL = "jeb.io/rev-s7";
    public static final String S7_FILE_EXT = ".s7blk";
    public static final String S7_ARCHIVE_EXT = ".s7zip";
    public static final int UNK_EXT_MAX_FILESIZE = 131072;
    public static final String propnameDisassembleCode = "DisassembleCode";
    public static final String propnameMapRawBlocksAtZero = "MapRawBlocksAtZero";
    public static final String propnameGenerateInterfaceDescriptionUnits = "GenerateInterfaceDescriptionUnits";
    public static final String propnameMapActualBytesForDataBlocks = "MapActualBytesForDataBlocks";
    public static final String propnameAugmentDisassembly = "AugmentDisassembly";

    public S7Identifier() {
        super(TYPE, 0.0);
    }

    @Override
    public double getPriority() {
        return 10.0;
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("S7 Parser", "Parser for Simatic S7 opaque binary blocks containing S7-300/400 PLC code and data", "PNF Software", Version.create(0, 1));
    }

    @Override
    public void initialize(IPropertyDefinitionManager iPropertyDefinitionManager) {
        super.initialize(iPropertyDefinitionManager);
        this.pdm.addDefinition(propnameDisassembleCode, PropertyTypeBoolean.create(true), "Disassemble the MC7 code contained in logic blocks (OB, FC, FB, SFC, SFB)");
        this.pdm.addDefinition(propnameMapRawBlocksAtZero, PropertyTypeBoolean.create(false), "Map the raw bytes of S7 blocks at the beginning of the image (address 0)");
        this.pdm.addDefinition(propnameGenerateInterfaceDescriptionUnits, PropertyTypeBoolean.create(true), "Generate additional text units describing interfaces for logic blocks and data blocks");
        this.pdm.addDefinition(propnameMapActualBytesForDataBlocks, PropertyTypeBoolean.create(true), "For data blocks, prefer mapping the actual (current values) bytes insteal of the default (initial values).");
        this.pdm.addDefinition(propnameAugmentDisassembly, PropertyTypeBoolean.create(true), "Augment the disassembly whenever possible, e.g. replace opaque parameter addressing with structure information.");
    }

    @Override
    public boolean acceptAnyInputBytes() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator, String string, Map<Object, Object> map) {
        if (string != null && string.endsWith(S7_ARCHIVE_EXT) && S7Identifier.checkBytes(iInput, 0, 80, 75, 3, 4)) {
            try (ZipFile zipFile = new ZipFile(iInput.getChannel());){
                Enumeration enumeration = zipFile.getEntries();
                while (enumeration.hasMoreElements()) {
                    ZipArchiveEntry zipArchiveEntry = (ZipArchiveEntry)enumeration.nextElement();
                    if (zipArchiveEntry.isDirectory() || !zipFile.canReadEntryData(zipArchiveEntry) || !zipArchiveEntry.getName().endsWith(S7_FILE_EXT) && zipArchiveEntry.getSize() > 131072L) continue;
                    InputStream inputStream = zipFile.getInputStream(zipArchiveEntry);
                    try {
                        byte[] byArray = IO.readInputStream(inputStream);
                        if (!rs.ce(byArray)) continue;
                        boolean bl = true;
                        return bl;
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
            }
            catch (IOException iOException) {}
        } else if (string != null && string.endsWith(S7_FILE_EXT)) {
            return rs.ce(iInput);
        }
        if (iInput == null) return false;
        if (iInput.getCurrentSize() > 131072L) return false;
        if (!rs.ce(iInput)) return false;
        return true;
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, Map<Object, Object> map) {
        kn kn2 = new kn(string, iInput, iUnitProcessor, iUnitCreator, this.pdm);
        return kn2;
    }
}

