/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.simatic;

import com.pnfsoftware.jeb.core.output.code.CodeDocumentPart;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.IInstructionOperand;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.AutoLabelPolicy;
import com.pnfsoftware.jeb.core.units.code.asm.render.GenericCodeFormatter;
import com.pnfsoftware.jeb.core.units.code.simatic.IS7Block;
import com.pnfsoftware.jeb.core.units.code.simatic.S7;
import com.pnfsoftware.jeb.core.units.codeobject.ICodeObjectUnit;
import com.pnfsoftware.jeb.core.units.codeobject.ISegmentInformation;
import com.pnfsoftware.jeb.corei.parsers.simatic.jC;
import com.pnfsoftware.jeb.corei.parsers.simatic.kn;
import com.pnfsoftware.jeb.corei.parsers.simatic.mo;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.format.TimeFormatter;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;

@Ser
public class Kh
extends GenericCodeFormatter<jC> {
    private kn ce() {
        ICodeObjectUnit iCodeObjectUnit = this.getCodeUnit().getCodeObjectContainer();
        if (iCodeObjectUnit instanceof kn) {
            return (kn)iCodeObjectUnit;
        }
        return null;
    }

    @Override
    public String generateHeader() {
        Object object = Strings.ff("S7 PLC Blocks Disassembly\nRefer to the Manual to get started on the analysis of S7 PLC code and data (%s)\n", "jeb.io/rev-s7");
        kn kn2 = this.ce();
        if (kn2 != null && !kn2.ce()) {
            object = (String)object + Strings.ff("Tip: To process multiple blocks, pack them in a zip archive having the extension '%s'\n", ".s7zip");
        }
        return object;
    }

    @Override
    public String generateExtraSegmentHeader(ISegmentInformation iSegmentInformation) {
        IS7Block iS7Block;
        kn kn2 = this.ce();
        if (kn2 != null && (iS7Block = kn2.getBlockAt(kn2.getLoaderInformation().getImageBase() + iSegmentInformation.getOffsetInMemory())) != null) {
            StringBuilder stringBuilder = new StringBuilder("Maps block ");
            Strings.ff(stringBuilder, "%s%d, version %d.%d, programmed in %s", new Object[]{S7.BlockType.fromId(iS7Block.getTypeId()), iS7Block.getNumber(), iS7Block.getVersion()[0], iS7Block.getVersion()[1], S7.LangType.fromId(iS7Block.getSourceLanguageId())});
            Strings.ff(stringBuilder, "\nModified on %s, interface changed on %s", TimeFormatter.formatTimestampLocal(iS7Block.getModificationTimestamp()), TimeFormatter.formatTimestampLocal(iS7Block.getInterfaceModificationTimestamp()));
            Strings.ff(stringBuilder, "\nName: %s, Family: %s, Author: %s", Strings.safe2(iS7Block.getMetadataBlockName(), "<UNKNOWN>"), Strings.safe2(iS7Block.getMetadataFamilyName(), "<UNKNOWN>"), Strings.safe2(iS7Block.getMetadataAuthorName(), "<UNKNOWN>"));
            Strings.ff(stringBuilder, "\nKey: 0x%X, CRC: 0x%X.", iS7Block.getKey(), iS7Block.getCrc());
            String string = kn2.getBlockEntryName(iS7Block);
            if (string != null) {
                Strings.ff(stringBuilder, "\nEntry name in archive: %s", string);
            }
            return stringBuilder.toString();
        }
        return super.generateExtraSegmentHeader(iSegmentInformation);
    }

    public void ce(long l2, jC jC2, IInstructionOperand iInstructionOperand, int n2, int n3, CodeDocumentPart codeDocumentPart) {
        mo mo2;
        kn kn2 = this.ce();
        if (kn2 != null && kn2.getPropertyManager().getBoolean("AugmentDisassembly") && (mo2 = (mo)iInstructionOperand).ce() != 1792 && mo2.ce() == 768) {
            long l3 = mo2.ce(l2);
            String string = this.getCodeUnit().getCodeModel().getLabelManager().getLabel(l3, 0L, AutoLabelPolicy.ON);
            codeDocumentPart.append(string);
            return;
        }
        super.formatOperand(l2, jC2, iInstructionOperand, n2, n3, codeDocumentPart);
    }

    @Override
    public /* synthetic */ void formatOperand(long l2, IInstruction iInstruction, IInstructionOperand iInstructionOperand, int n2, int n3, CodeDocumentPart codeDocumentPart) {
        this.ce(l2, (jC)iInstruction, iInstructionOperand, n2, n3, codeDocumentPart);
    }
}

