/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.simatic;

import com.pnfsoftware.jeb.core.units.code.simatic.IS7Block;
import com.pnfsoftware.jeb.core.units.code.simatic.S7;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.format.TimeFormatter;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;

@Ser
public abstract class Cg
implements IS7Block {
    @Override
    public S7.LangType getSourceLanguage() {
        return S7.LangType.fromId(this.getSourceLanguageId());
    }

    @Override
    public S7.BlockType getType() {
        return S7.BlockType.fromId(this.getTypeId());
    }

    @Override
    public boolean isInstanceDataBlock() {
        if (this.getType() == S7.BlockType.DI) {
            return true;
        }
        if (this.getType() == S7.BlockType.DB && this.getInterfaceSize() > 0) {
            int n2 = this.getBlockByte(this.getInterfaceOffset());
            return n2 == 10;
        }
        return false;
    }

    protected String ce(byte[] byArray, int n2) {
        return Cg.ce(8, byArray, n2);
    }

    public static String ce(int n2, byte[] byArray, int n3) {
        char c2;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n3; i < n3 + n2 && (c2 = (char)(byArray[i] & 0xFF)) != '\u0000'; ++i) {
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    protected long mm(byte[] byArray, int n2) {
        int n3 = EndianUtil.bigEndianBytesToInt(byArray, n2);
        Assert.a(n3 >= 0 && n3 < 86400000);
        short s2 = EndianUtil.bigEndianBytesToShort(byArray, n2 + 4);
        long l2 = (441763200L + (long)s2 * 86400L) * 1000L + (long)n3;
        return l2;
    }

    @Override
    public String getName() {
        return Cg.ce(this.getType(), this.getNumber());
    }

    public static String ce(S7.BlockType blockType, int n2) {
        return Strings.ff("%s%d", blockType == null ? "?" : blockType.toString(), n2);
    }

    public String toString() {
        return Strings.ff("%s%d, version %d.%d, programmed in %s, modified on %s, interface modified on %s", new Object[]{this.getType(), this.getNumber(), this.getVersion()[0], this.getVersion()[1], this.getSourceLanguage(), TimeFormatter.formatTimestampLocal(this.getModificationTimestamp()), TimeFormatter.formatTimestampLocal(this.getInterfaceModificationTimestamp())});
    }
}

