/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.simatic;

import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.processor.AbstractProcessor;
import com.pnfsoftware.jeb.core.units.code.asm.processor.BytesBlock;
import com.pnfsoftware.jeb.core.units.code.asm.processor.ProcessorException;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.corei.parsers.simatic.jC;
import com.pnfsoftware.jeb.corei.parsers.simatic.lc;
import com.pnfsoftware.jeb.corei.parsers.simatic.mo;
import com.pnfsoftware.jeb.corei.parsers.simatic.nM;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import com.pnfsoftware.jeb.util.io.Endianness;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import java.nio.ByteOrder;
import java.util.Arrays;

@Ser
public class AD
extends AbstractProcessor<jC> {
    private static final ByteOrder ce = ByteOrder.BIG_ENDIAN;

    public AD() {
        super(6, 32, Endianness.BIG_ENDIAN, 1);
    }

    @Override
    public ProcessorType getType() {
        return lc.mm;
    }

    protected jC ce(byte[] byArray, int n2, int n3) throws ProcessorException {
        mo[] moArray;
        int n4;
        if (n2 < 0 || n2 >= n3 || n2 >= byArray.length) {
            return null;
        }
        int n5 = n2;
        if ((n4 = byArray[n5++] & 0xFF) >= nM.Sk.length) {
            throw new RuntimeException();
        }
        nM.ri ri2 = nM.Sk[n4];
        mo mo2 = null;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = ri2.mm & 0xFF;
        switch (n9) {
            case 0: {
                break;
            }
            case 1: {
                int n10 = byArray[n5++] & 0xFF;
                if (n10 == 0) break;
                if (n10 >= 16 && n10 <= 127) {
                    ri2 = ri2.mH[0];
                } else if (n10 >= 144 && n10 <= 239) {
                    ri2 = ri2.mH[1];
                } else {
                    throw new ProcessorException();
                }
                Assert.a(ri2 != null && (ri2.mm & 0xFF) == 2);
                int n11 = n10 & 0x7F;
                if ((n11 & 8) != 0) {
                    throw new RuntimeException("Reserved it should be 0");
                }
                int n12 = n11 >> 4;
                if (n12 < 1 || n12 > 6) {
                    throw new RuntimeException("Illegal memory type");
                }
                int n13 = n11 & 0xF;
                n7 |= n12 | n13 << 20;
                break;
            }
            case 4: {
                int n14 = byArray[n5++] & 0xFF;
                if ((n14 & 0x1F) == 0) break;
                throw new RuntimeException("Unexpected");
            }
            case 5: {
                int n15 = byArray[n5++] & 0xFF;
                if (n15 == 0) break;
                if (n15 < 1 || n15 > 12) {
                    throw new RuntimeException("Unexpected");
                }
                n7 |= n15 << 28;
                break;
            }
            case 6: {
                if ((byArray[n5] & 0x80) == 0) break;
                ri2 = ri2.mH[0];
                break;
            }
            case 7: {
                int n16 = byArray[n5++] & 0xFF;
                if (n16 == 0) break;
                int n17 = n16 >> 6 & 2 | n16 >> 3 & 1;
                ri2 = ri2.mH[n17];
                Assert.a(ri2 != null && (ri2.mm & 0xFF) == 8);
                int n12 = n16 & 7;
                Assert.a(n12 >= 1 && n12 <= 6);
                n7 |= n12;
                int n18 = n16 >> 4 & 7;
                n8 |= n18 | 0x3000;
                break;
            }
            case 9: {
                int n19 = byArray[n5++] & 0xFF;
                if (n19 == 5) break;
                ri2 = ri2.mH[0];
                break;
            }
            case 11: {
                int n20 = byArray[n5++] & 0xFF;
                if (n20 == 0) break;
                if (n20 == 1) {
                    ri2 = ri2.mH[0];
                    break;
                }
                Assert.fail();
                break;
            }
            case 12: {
                int n21 = byArray[n5++] & 0xFF;
                if ((n21 & 0xF) == 1) {
                    n6 = n21 >> 4;
                    break;
                }
                if (n21 == 52) {
                    ri2 = ri2.mH[1];
                    break;
                }
                if (n21 == 68) {
                    ri2 = ri2.mH[2];
                    break;
                }
                if (n21 == 84) {
                    ri2 = ri2.mH[3];
                    break;
                }
                if (n21 == 54) {
                    ri2 = ri2.mH[4];
                    break;
                }
                if (n21 == 70) {
                    ri2 = ri2.mH[5];
                    break;
                }
                if (n21 == 86) {
                    ri2 = ri2.mH[6];
                    break;
                }
                ri2 = ri2.mH[0];
                break;
            }
            case 14: {
                int n22 = byArray[n5++] & 0xFF;
                int n23 = n22 & 0xF;
                ri2 = ri2.mH[n23];
                Assert.a(ri2 != null);
                break;
            }
            case 15: {
                int n24 = byArray[n5++] & 0xFF;
                if (n24 == 0) break;
                ri2 = ri2.mH[0];
                Assert.a(ri2 != null && (ri2.mm & 0xFF) == 16);
                n8 = (n24 & 8) == 0 ? (n8 |= 0x20) : (n8 |= 0x21);
                n8 |= 0x40000000;
                int n25 = n24 >> 4 & 7;
                n7 |= n25;
                break;
            }
            case 17: {
                int n26 = byArray[n5++] & 0xFF;
                if (n26 == 0) break;
                ri2 = ri2.mH[n26 >> 2 & 1];
                Assert.a(ri2 != null && (ri2.mm & 0xFF) == 18);
                int n27 = n26 & 3;
                if (n27 == 0) {
                    throw new RuntimeException();
                }
                n7 |= n27 << 12;
                int n12 = n26 >> 4;
                if (n12 > 6) {
                    throw new RuntimeException();
                }
                if (n12 == 0) {
                    n12 = 16;
                }
                n7 |= n12;
                break;
            }
            case 19: {
                int n28;
                int n29 = byArray[n5++] & 0xFF;
                if (n29 == 0) break;
                ri2 = ri2.mH[0];
                Assert.a(ri2 != null && (ri2.mm & 0xFF) == 20);
                if (n4 == 186) {
                    Assert.a((n29 & 8) == 0);
                    n7 |= 0x1000;
                } else if (n4 == 187) {
                    n28 = (n29 & 8) == 0 ? 1 : 0;
                    n7 |= n28 != 0 ? 8192 : 12288;
                } else {
                    Assert.fail();
                }
                n28 = n29 & 7;
                if (n28 > 6) {
                    throw new RuntimeException();
                }
                if (n28 == 0) {
                    n28 = 16;
                }
                n7 |= n28;
                int n12 = n29 >> 4 & 7;
                n8 |= n12 | 0x3000;
                break;
            }
            case 21: {
                int n12;
                int n30 = byArray[n5++] & 0xFF;
                if (n30 != 0) {
                    ri2 = ri2.mH[0];
                    Assert.a(ri2 != null && (ri2.mm & 0xFF) == 22);
                    n8 = (n30 & 8) == 0 ? (n8 |= 0x20) : (n8 |= 0x21);
                    n8 |= 0x40000000;
                    Assert.a((n30 & 0x80) == 0);
                    int n31 = n30 >> 4 & 7;
                    n12 = (n30 & 3) << 12;
                    n7 |= n31 | n12;
                    break;
                }
                Assert.fail();
                break;
            }
            case 23: {
                int n32 = byArray[n5++] & 0xFF;
                if (n32 == 0) break;
                ri2 = ri2.mH[0];
                Assert.a(ri2 != null && (ri2.mm & 0xFF) == 24);
                n7 |= (n32 & 0x80) == 0 ? 8 : 9;
                int n33 = n32 >> 4 & 7;
                n8 |= n33 | 0x2000;
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                int n34 = byArray[n5++] & 0xFF;
                nM.ri[] riArray = null;
                switch (n4) {
                    case 251: {
                        riArray = nM.EC;
                        break;
                    }
                    case 254: {
                        riArray = nM.F;
                        break;
                    }
                    case 255: {
                        riArray = nM.YT;
                        break;
                    }
                    default: {
                        Assert.fail();
                    }
                }
                if (n34 >= riArray.length) {
                    throw new RuntimeException(Strings.ff("TBI: Opcode: %02X %02X", n4, n34));
                }
                ri2 = riArray[n34];
                if ((ri2.mm & 0xFF) != 28) break;
                n6 = n34 & 0xF;
                break;
            }
            default: {
                throw new RuntimeException(Strings.ff("insnflags= 0x%X", ri2.mm));
            }
        }
        n8 |= ri2.ok;
        if ((n7 |= ri2.Rs) != 0) {
            switch (ri2.Rs & 0xF0000) {
                case 0: 
                case 524288: {
                    break;
                }
                case 262144: {
                    n6 = byArray[n5++] & 0x7F;
                    break;
                }
                case 65536: {
                    n6 = byArray[n5++] & 0xFF;
                    break;
                }
                case 327680: {
                    n6 = byArray[n5++];
                    break;
                }
                case 131072: {
                    n6 = EndianUtil.bytesToShort(byArray, n5, ce) & 0xFFFF;
                    n5 += 2;
                    break;
                }
                case 393216: {
                    n6 = EndianUtil.bytesToShort(byArray, n5, ce);
                    n5 += 2;
                    break;
                }
                case 196608: 
                case 458752: {
                    n6 = EndianUtil.bytesToInt(byArray, n5, ce);
                    n5 += 4;
                    break;
                }
                default: {
                    throw new RuntimeException(Strings.ff("opndflags=0x%X", ri2.Rs));
                }
            }
            mo2 = new mo(n7, n6, n8);
        }
        BytesBlock bytesBlock = new BytesBlock(Arrays.copyOfRange(byArray, n2, n5));
        if (mo2 == null) {
            moArray = new mo[]{};
        } else {
            mo[] moArray2 = new mo[1];
            moArray = moArray2;
            moArray2[0] = mo2;
        }
        mo[] moArray3 = moArray;
        return new jC(bytesBlock, ri2, moArray3);
    }

    @Override
    protected /* synthetic */ IInstruction parseAtInternal(byte[] byArray, int n2, int n3) throws ProcessorException {
        return this.ce(byArray, n2, n3);
    }
}

