/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.machofat;

import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.corei.parsers.machofat.Qb;
import java.nio.ByteBuffer;
import java.util.Map;

public class MachOFatIdentifier
extends AbstractUnitIdentifier {
    public static final String TYPE = "machofat";
    public static final int FAT_MAGIC = -889275714;
    public static final int FAT_CIGAM = -1095041334;
    public static final int FAT_MAGIC64 = -889275713;
    public static final int FAT_CIGAM64 = -1078264118;

    public MachOFatIdentifier() {
        super(TYPE, 0.0);
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("Mach-O fat files loader", "Apple Mach-O fat files parser", "PNF Software", Version.create(0, 0, 1));
    }

    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator, String string, Map<Object, Object> map) {
        if (iInput == null) {
            return false;
        }
        ByteBuffer byteBuffer = iInput.getHeader();
        if (byteBuffer.limit() <= 8) {
            return false;
        }
        int n2 = byteBuffer.getInt();
        if (n2 == -889275713 || n2 == -1078264118) {
            throw new RuntimeException("TBI: 64b Mach-O FAT");
        }
        if (n2 == -889275714 || n2 == -1095041334) {
            short s2 = byteBuffer.getShort();
            if (s2 != 0) {
                return false;
            }
            short s3 = byteBuffer.getShort();
            return s3 < 43;
        }
        return false;
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, Map<Object, Object> map) {
        Qb qb = new Qb(string, iInput, iUnitProcessor, iUnitCreator, this.pdm);
        return qb;
    }
}

