/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.llvmbc;

import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.input.FileInput;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.output.IUnitFormatter;
import com.pnfsoftware.jeb.core.output.UnitFormatterUtil;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.AbstractBinaryUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.core.units.code.android.AndroidSdkUtil;
import com.pnfsoftware.jeb.corei.parsers.llvmbc.ca;
import com.pnfsoftware.jeb.util.base.OSType;
import com.pnfsoftware.jeb.util.concurrent.CommandExec;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;

@Ser
public class ri
extends AbstractBinaryUnit {
    private static final ILogger ce = GlobalLog.getLogger(ri.class);
    @SerId(value=1)
    private String mm;

    public ri(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, IPropertyDefinitionManager iPropertyDefinitionManager) {
        super(null, iInput, "llvmbc", string, iUnitProcessor, iUnitCreator, iPropertyDefinitionManager);
    }

    @Override
    protected boolean processInternal() {
        block20: {
            File file = null;
            boolean bl = false;
            File file2 = null;
            try {
                String string;
                File file3;
                File file4 = AndroidSdkUtil.locateBestNDK(true);
                String string2 = null;
                String string3 = null;
                switch (OSType.determine()) {
                    case WIN64: {
                        string2 = "windows-x86_64";
                        string3 = "llvm-dis.exe";
                        break;
                    }
                    case LINUX64: {
                        string2 = "linux-x86_64";
                        string3 = "llvm-dis";
                        break;
                    }
                    case OSX64: {
                        string2 = "darwin-x86_64";
                        string3 = "llvm-dis";
                    }
                }
                if (string2 == null || string3 == null || !(file3 = new File(file4, string = "toolchains/llvm/prebuilt/" + string2 + "/bin/" + string3)).exists()) break block20;
                IInput iInput = this.getInput();
                if (iInput instanceof FileInput) {
                    file = ((FileInput)iInput).getFile();
                } else {
                    bl = true;
                    try (InputStream inputStream = iInput.getStream();){
                        file = IO.createTempFile();
                        file.deleteOnExit();
                        IO.writeFile(file, IO.readInputStream(inputStream));
                    }
                }
                if (file != null) {
                    file2 = IO.createTempFile(file.getName(), ".decoded");
                    file2.delete();
                    file2.deleteOnExit();
                    boolean bl2 = new CommandExec(3000L).execute(file3.getAbsolutePath(), "-o=" + file2.getAbsolutePath(), file.getAbsolutePath());
                    if (bl2 && file2.isFile()) {
                        List<String> list = IO.readLines(file2, Charset.defaultCharset());
                        for (int i = 0; i < list.size(); ++i) {
                            String string4 = list.get(i);
                            if (string4.startsWith("; ModuleID =")) {
                                list.set(i, "; ModuleID = " + this.getName());
                            }
                            if (!string4.startsWith("source_filename =")) continue;
                            list.set(i, Strings.ff("source_filename = \"%s\"", this.getName()));
                        }
                        this.mm = Strings.join("\n", list);
                    }
                }
            }
            catch (Exception exception) {
                ce.catchingSilent(exception);
                if (file != null && bl) {
                    file.delete();
                }
                if (file2 == null) break block20;
                file2.delete();
            }
        }
        this.setProcessed(true);
        return true;
    }

    @Override
    public IUnitFormatter getFormatter() {
        IUnitFormatter iUnitFormatter = super.getFormatter();
        if (this.mm != null && UnitFormatterUtil.getPresentationByIdentifier(iUnitFormatter, 1L) == null) {
            iUnitFormatter.addPresentation(new ca(this, 1L, "Decoded", true), false);
        }
        return iUnitFormatter;
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder("LLVM bitcode binary file\n");
        if (this.mm == null) {
            stringBuilder.append("Use llvm-dis to disassemble this file\n");
        }
        return stringBuilder.toString();
    }
}

